﻿# -*- coding: utf-8 -*-

import sys
import os
import re
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import json
import xbmcvfs
import time
from datetime import datetime, timedelta
import requests
from urllib.parse import parse_qsl, urlencode
from xml.dom import minidom
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


HOST_AND_PATH		= sys.argv[0]
ADDON_HANDLE		= int(sys.argv[1])
params						= dict(parse_qsl(sys.argv[2][1:]))
dialog							= xbmcgui.Dialog()
addon							= xbmcaddon.Addon()
addon_id					= addon.getAddonInfo('id')
addon_name				= addon.getAddonInfo('name')
addon_version			= addon.getAddonInfo('version')
addon_desc				= addon.getAddonInfo('description')
addonPath					= xbmcvfs.translatePath(addon.getAddonInfo('path')).encode('utf-8').decode('utf-8')
dataPath						= xbmcvfs.translatePath(addon.getAddonInfo('profile')).encode('utf-8').decode('utf-8')
defaultFanart				= os.path.join(addonPath, 'resources', 'fanart.jpg')
icon								= os.path.join(addonPath, 'resources', 'icon.png')
KODI_ov20					= int(xbmc.getInfoLabel('System.BuildVersion')[0:2]) >= 20
BASE_URL					= 'https://www.tierwelt-live.de'
agent_WEB					= 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0'
head_TWL					= {'User-Agent': agent_WEB, 'Referer': f'{BASE_URL}/', 'Cache-Control': 'public, max-age=300', 'Accept': 'application/json, application/x-www-form-urlencoded, text/plain, */*', 'DNT': '1', 'Upgrade-Insecure-Requests': '1', 'Accept-Encoding': 'gzip', 'Accept-Language': 'de-DE,de;q=0.9,en;q=0.8'}


xbmcplugin.setContent(ADDON_HANDLE, 'videos')
xbmcplugin.addSortMethod(ADDON_HANDLE, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE)


def build_mass(body):
	return f"{HOST_AND_PATH}?{urlencode(body)}"


def getContent(url, method='GET', queries='JSON', headers=head_TWL, redirects=True, verify=True, data=None, json=None, timeout=30):
	ANSWER, simple = None, requests.Session()
	try:
		response = simple.request(method, url, headers=headers, allow_redirects=redirects, verify=verify, timeout=timeout)
		ANSWER = response.json() if queries == 'JSON' else response.text if queries == 'TEXT' else response
		#xbmc.log(f"[{addon_id} v.{addon_version}] (common.getContent) === CALLBACK === STATUS : {response.status_code} || URL : {response.url} || HEADER : {response.request.headers} ===", xbmc.LOGINFO)
	except requests.exceptions.RequestException as exc:
		xbmc.log(f"[{addon_id} v.{addon_version}] ERROR - EXEPTION - ERROR ##### URL : {url} === FAILURE : {exc} #####", xbmc.LOGERROR)
		dialog.notification(addon_name, 'Für diesen Eintrag wurden KEINE Daten empfangen !!!', xbmcgui.NOTIFICATION_ERROR)
		return sys.exit(0)
	return ANSWER


def create_entries(metadata, SIGNS=None):
	listitem = xbmcgui.ListItem(metadata['Title'])
	vinfo = listitem.getVideoInfoTag() if KODI_ov20 else {}
	if KODI_ov20: vinfo.setTitle(metadata['Title'])
	else: vinfo['Title'] = metadata['Title']
	description = metadata['Plot'] if metadata.get('Plot') not in ['', 'None', None] else ' '
	if KODI_ov20: vinfo.setPlot(description)
	else: vinfo['Plot'] = description
	if str(metadata.get('Duration')).isdecimal():
		if KODI_ov20: vinfo.setDuration(int(metadata['Duration']))
		else: vinfo['Duration'] = metadata['Duration']
	if metadata.get('Aired', ''):
		if KODI_ov20: vinfo.setFirstAired(metadata['Aired'])
		else: vinfo['Aired'] = metadata['Aired']
	if str(metadata.get('Aired'))[6:10].isdecimal():
		if KODI_ov20: vinfo.setYear(int(metadata['Aired'][6:10]))
		else: vinfo['Year'] = metadata['Aired'][6:10]
	if metadata.get('Mpaa', ''):
		if KODI_ov20: vinfo.setMpaa(str(metadata['Mpaa']))
		else: vinfo['Mpaa'] = str(metadata['Mpaa'])
	if metadata.get('Studio', ''):
		if KODI_ov20: vinfo.setStudios([metadata['Studio']])
		else: vinfo['Studio'] = metadata['Studio']
	if metadata.get('Mediatype', ''):
		if KODI_ov20: vinfo.setMediaType(metadata['Mediatype'])
		else: vinfo['Mediatype'] = metadata['Mediatype']
	picture = metadata.get('Image', icon)
	listitem.setArt({'icon': icon, 'thumb': picture, 'poster': picture, 'fanart': defaultFanart})
	if picture != icon:
		listitem.setArt({'fanart': picture})
	if metadata.get('Reference') == 'Single':
		listitem.setProperty('IsPlayable', 'true')
	if not KODI_ov20: listitem.setInfo('Video', vinfo)
	return listitem


def addDir(params, listitem, folder=True):
	uws = build_mass(params)
	listitem.setPath(uws)
	return xbmcplugin.addDirectoryItem(ADDON_HANDLE, uws, listitem, folder)


API_CONFIG = getContent('https://twl-prod-static.s3.amazonaws.com/configs/projectConfig_smartclip.json')
API_VERSION = getContent(API_CONFIG['ivms']['version'])['version_name']
VIDEO_API = API_CONFIG['ivms']['restapi'].replace('[version]', API_VERSION)


def getFeedRSS():
	"""
	Read and convert RSS Feed of 'Tierwelt live' into JSON
	"""
	resources = getContent('https://twl-aggregation.s3.amazonaws.com/livestream.xml', queries='TEXT').encode('utf-8')
	xml = minidom.parseString(resources).getElementsByTagName('rss')
	channel = xml[0].getElementsByTagName('channel')
	items = channel[0].getElementsByTagName('item')
	rss_items = list()

	for item in items:
		DESC, RATED, AIRED = (None for _ in range(3))
		url = item.getElementsByTagName('media:content')[0].getAttribute('url')
		if item.getElementsByTagName('media:description')[0].firstChild is not None:
			DESC = item.getElementsByTagName('media:description')[0].firstChild.wholeText
		if item.getElementsByTagName('media:rating')[0].firstChild is not None:
			RATED = f"tv-{item.getElementsByTagName('media:rating')[0].firstChild.wholeText}"
		if item.getElementsByTagName('pubDate')[0].firstChild is not None:
			pubDate = item.getElementsByTagName('pubDate')[0].firstChild.wholeText
			try:
				available = datetime(*(time.strptime(pubDate[5:25], '%d %b %Y %H:%M:%S')[0:6])) # Mon, 08 Sep 2025 11:30:44 +0000
				AIRED = available.strftime('%d.%m.%Y')
			except: pass
		entries = dict({
			'title': item.getElementsByTagName('title')[0].firstChild.wholeText,
			'teaser': DESC,
			'images': item.getElementsByTagName('media:thumbnail')[0].getAttribute('url'),
			'crypto': re.compile('cdn.svmcdn4.com/hls/twl/(.+?)_hls720p.mp4/playlist.m3u8').findall(url)[0],
			'filesize': int(item.getElementsByTagName('media:content')[0].getAttribute('fileSize')),
			'mediatype': item.getElementsByTagName('media:content')[0].getAttribute('type'),
			'channels': int(item.getElementsByTagName('media:content')[0].getAttribute('channels')),
			'width': int(item.getElementsByTagName('media:content')[0].getAttribute('width')),
			'height': int(item.getElementsByTagName('media:content')[0].getAttribute('height')),
			'bitrate': int(item.getElementsByTagName('media:content')[0].getAttribute('bitrate')),
			'expression': item.getElementsByTagName('media:content')[0].getAttribute('expression'),
			'duration_in_secs': int(item.getElementsByTagName('media:content')[0].getAttribute('duration')),
			'language': item.getElementsByTagName('media:content')[0].getAttribute('lang'),
			'rating': RATED,
			'aired': AIRED})
		rss_items.append(entries)
	return json.loads(json.dumps({'rss': rss_items}))


def list_pages():
	"""
	Show plugin main menu with pages "Aktuelle Livestreams, Kanäle, Neueste Filme, Themen, Tierporträts".
	https://d36olg7tmj6zg3.cloudfront.net/20250908135239/restapi/pages/[home, kanaele, themen, tiere].json
	https://twl-ivms2-restapi.s3.amazonaws.com/20250908135239/restapi/containers/2976.json = Neueste Filme
	"""
	xbmcplugin.setPluginCategory(ADDON_HANDLE, 'Start')
	addDir({'mode': 'list_videos', 'slug': 0, 'category': 'rss'}, create_entries({'Title': 'Aktuelle Livestreams', 'Plot': addon_desc}))
	addDir({'mode': 'list_videos', 'slug': 2976, 'category': 'movie'}, create_entries({'Title': 'Neueste Filme', 'Plot': addon_desc}))
	for selection in ['kanaele', 'themen', 'tiere']:
		categories = getContent(f"{VIDEO_API}pages/{selection}.json")['items']
		for category in categories:
			com_title = category['unicode'].replace('Tiere', 'Tierporträts')
			FETCH_UNO = create_entries({'Title': com_title, 'Plot': addon_desc})
			addDir({'mode': 'list_categories', 'slug': category['id']}, FETCH_UNO)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)


def list_categories(slug, childs):
	"""
	Create the list of video categories in the Kodi interface.
	https://twl-ivms2-restapi.s3.amazonaws.com/20250908135239/restapi/containers/2980.json
	"""
	xbmcplugin.setPluginCategory(ADDON_HANDLE, 'Kategorien')
	if childs == False:
		categories = getContent(f"{VIDEO_API}containers/{slug}.json")['items']
	else:
		categories = list(childs[1:-1].split(', '))
	for category in categories:
		if childs == False:
			saw_module = category['module']
			saw_cid = category['id']
			saw_title = category['unicode']
		else:
			saw_module = 'channel'
			saw_cid = category
		infos = getContent(f"{VIDEO_API}{saw_module}s/{str(saw_cid)}.json")
		if childs != False:
			saw_title = infos['title']
		com_plot = (infos.get('description', '') or infos.get('teaser', '') or '')
		com_thumb = infos['images'][0].get('url', icon) if len(infos.get('images', [])) > 0 else icon
		ACTION = {'mode': 'list_videos', 'slug': saw_cid, 'category': saw_module}
		if 'child_channels' in infos and len(infos.get('child_channels', '')) > 0:
			ACTION = {'mode': 'list_categories', 'slug': 0, 'childs': infos['child_channels']}
		FETCH_UNO = {'Title': saw_title, 'Plot': com_plot, 'Image': com_thumb}
		addDir(ACTION, create_entries(FETCH_UNO))
	xbmcplugin.endOfDirectory(ADDON_HANDLE)


def list_videos(slug, page):
	"""
	Create the list of playable videos in the Kodi interface.
	"""
	xbmcplugin.setPluginCategory(ADDON_HANDLE, 'Videos')
	if page == 'rss':
		category = getFeedRSS()
		videos = category['rss']
	elif page == 'movie':
		category = getContent(f"{VIDEO_API}containers/{slug}.json")
		videos = category['items']
	else:
		category = getContent(f"{VIDEO_API}{page}s/{slug}.json")

	if page == 'animal':
		containers = getContent(f"{VIDEO_API}containers/{str(category['containers'][0])}.json")
		videos = containers['items']
	elif page not in ['rss', 'movie', 'animal']:
		videos = category['contains_media']

	for video in videos:
		if page == 'rss':
			FETCH_UNO = {'Title': video['title'], 'Plot': (video.get('teaser', '') or ''), 'Duration': int(video.get('duration_in_secs', 0)), 'Aired': video.get('aired', ''), \
				'Year': video.get('aired', ''), 'Mpaa': video.get('rating', ''), 'Studio': 'tierwelt-live.de', 'Mediatype': 'episode', 'Image': video['images'], 'Reference': 'Single'}
			addDir({'mode': 'play_video', 'slug': video['crypto'], 'uuid': video['crypto']}, create_entries(FETCH_UNO), False)
		else:
			media = getContent(f"{VIDEO_API}media/{str(video['id'])}.json") if page in ['animal', 'movie'] else video
			com_uuid = media.get('uuid', 'DEFAULT')
			com_title = f"{media['title']} - {media['subtitle']}" if media.get('subtitle', '') else media['title']
			com_plot = (media.get('description', '') or media.get('teaser', '') or '')
			com_duration = int(round(media.get('duration_in_ms', 0)/1000))
			com_aired = media.get('web_airdate', '')
			com_thumb = media['images'][0].get('url', icon) if len(media.get('images', [])) > 0 else icon
			ACTION = {'mode': 'play_video', 'slug': video['id'] if page in ['animal', 'movie'] else video['pk'], 'uuid': com_uuid}
			FETCH_DUE = {'Title': com_title, 'Plot': com_plot, 'Duration': com_duration, 'Aired': com_aired, 'Year': com_aired, \
				'Studio': 'tierwelt-live.de', 'Mediatype': 'episode', 'Image': com_thumb, 'Reference': 'Single'}
			addDir(ACTION, create_entries(FETCH_DUE), False)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)


def play_video(slug, uuid):
	"""
	Play a video by the provided path.
	"""
	if uuid == 'DEFAULT':
		uuid = getContent(f"{VIDEO_API}media/{slug}.json")['uuid']
	play_item = xbmcgui.ListItem(path = f"https://cdn-segments.tierwelt-live.de/{uuid}_twl_720p.m4v/playlist.m3u8", offscreen=True)
	play_item.setMimeType('application/vnd.apple.mpegurl'), play_item.setContentLookup(False)
	xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, play_item)


def router():
	"""
	Router function that calls other functions depending on the provided paramstring.
	"""
	if params:
		if params['mode'] == 'list_categories':
			list_categories(params['slug'], params.get('childs', False))
		elif params['mode'] == 'list_videos':
			list_videos(params['slug'], params['category'])
		elif params['mode'] == 'play_video':
			play_video(params['slug'], params.get('uuid', 'DEFAULT'))
		else:
			raise ValueError(f"Ungültiger Parameterstring : {params} !!!")
	else:
		list_pages()


router()
