﻿# -*- coding: utf-8 -*-

from .common import *


def _header(REFERRER=None, USERTOKEN=None):
	header = {}
	header['Cache-Control'] = 'public, max-age=300'
	header['Accept'] = 'application/json, application/x-www-form-urlencoded, text/html, */*'
	header['User-Agent'] = defaultAgent
	header['DNT'] = '1'
	header['Upgrade-Insecure-Requests'] = '1'
	header['Accept-Encoding'] = 'gzip'
	header['Accept-Language'] = 'de-DE,de;q=0.9,en;q=0.8'
	header['Origin'] = BASE_URL[:-1]
	if REFERRER: header['Referer'] = REFERRER
	if USERTOKEN: header['Authorization'] = USERTOKEN
	return header

class Transmission(object):
	def __init__(self):
		self.maxTokenTime = tokenDelay*60*60 # Token-Time (Seconds) before clear the Token and delete Token-File
		self.tempSERV_folder = tempSERV
		self.servus_file = FREE_SECRET
		self.verify_ssl = verify_connection

	def convert_epoch(self, epoch):
		CIPHER = datetime(1970,1,1) + timedelta(seconds=int(epoch))
		return CIPHER.strftime('%d.%m.%Y - %H:%M:%S')

	def check_FreeToken(self):
		forceRenew, USERTOKEN, USERCOUNTRY = (False for _ in range(3))
		SELECT_PATH, SECURITY, self.TIME_UTC = self.tempSERV_folder, self.servus_file, time.time()
		if self.maxTokenTime > 1 and SECURITY is not None and os.path.isfile(SECURITY):
			try:
				self.TOKEN_UTC = (os.path.getmtime(SECURITY) + self.maxTokenTime)
				debug_MS(f"(utilities.check_FreeToken) ### SESSION-Time (utc NOW) = {self.convert_epoch(self.TIME_UTC)} || VALID until (utc SESSION) = {self.convert_epoch(self.TOKEN_UTC)} ###")
				if self.TIME_UTC < self.TOKEN_UTC:
					ACC_DATA = preserve(SECURITY)
					USERTOKEN, USERCOUNTRY = ACC_DATA['token'], ACC_DATA['country_code']
					debug_MS("(utilities.check_FreeToken) ### NOTHING CHANGED - TOKENFILE IS OKAY ###")
				else:
					debug_MS("(utilities.check_FreeToken) ### TIMEOUT FOR TOKEN - DELETE TOKENFILE ###")
					forceRenew = True
			except:
				failing("(utilities.check_FreeToken) XXXXX !!! ERROR = TOKENFILE [TOKENFORMAT IS INVALID] = ERROR !!! XXXXX")
				forceRenew = True
		else:
			debug_MS("(utilities.check_FreeToken) ### NOTHING FOUND - CREATE TOKENFILE FOR SERVUSTV ###")
			forceRenew = True
		if forceRenew: # https://tv-api.redbull.com/v3/session?locale=de-DE&os_family=android&category=tablet
			if SECURITY is not None and os.path.isfile(SECURITY):
				shutil.rmtree(SELECT_PATH, ignore_errors=True)
			CODING = self.retrieveContent(f"{SERTV_AV3}session?namespace=stv&category=personal_computer&os_family=http", REF=BASE_URL)
			if CODING:
				if self.maxTokenTime > 1:
					debug_MS(f"(utilities.check_FreeToken) ***** NEW TOKENFILE CREATED : {CODING} *****")
					if not xbmcvfs.exists(SELECT_PATH) and not os.path.isdir(SELECT_PATH):
						xbmcvfs.mkdirs(SELECT_PATH)
					preserve(SECURITY, 'JSON', CODING)
				else:
					debug_MS("(utilities.check_FreeToken) ~~~ YOU ARE IN LIVE-SESSION WITHOUT SAVING TOKEN - EVERTHING OKAY ~~~")
				USERTOKEN, USERCOUNTRY = CODING['token'], CODING['country_code']
		return (USERTOKEN, USERCOUNTRY)

	def retrieveContent(self, url, method='GET', queries='JSON', REF=None, raising=True, forcing=False, headers={}, redirects=True, data=None, json=None, timeout=30):
		retries, (SHARING, NATION, ANSWER, NEW_CODING) = 0, (None for _ in range(4))
		if forcing is True:
			SHARING, NATION = self.check_FreeToken()
		if url.startswith('http'):
			try:
				response = requests.request(method, url, headers=_header(REF, SHARING), allow_redirects=redirects, verify=self.verify_ssl, timeout=timeout)
				if raising is True: response.raise_for_status()
				ANSWER = response.json() if queries == 'JSON' else response.text if queries == 'TEXT' else response
				debug_MS(f"(utilities.retrieveContent) === CALLBACK === STATUS : {response.status_code} || URL : {response.url} || HEADER : {_header(REF, SHARING)} ===")
			except requests.exceptions.RequestException as exc:
				failing(f"(utilities.retrieveContent) ERROR - EXEPTION - ERROR ##### URL : {url} === FAILURE : {exc} #####")
				dialog.notification(translation(30521).format('URL'), translation(30523).format(exc), icon, 12000)
				return sys.exit(0)
		else:
			def getCollected(suffix_URL, token_TRANSFER=None):
				debug_MS(f"(utilities.getCollected) === suffix_URL : {suffix_URL} || token_TRANSFER : {token_TRANSFER} ===")
				recentURL = NEXT_SERTV+token_TRANSFER+suffix_URL if token_TRANSFER else NEXT_SERTV+addon.getSetting('servus_staticCODE')+suffix_URL
				return recentURL
			while not ANSWER and retries < 3: # 2 x Wiederholungen (gesamt=3) für den URL-Request ::: da der Code für die API_JOYN evtl. wieder geändert wurde
				retries += 1
				try:
					endURL = getCollected(url, NEW_CODING)
					response = requests.request(method, endURL, headers=_header(REF, SHARING), allow_redirects=redirects, verify=self.verify_ssl, timeout=timeout)
					if raising is True: response.raise_for_status()
					VALID_JSON = response.json() if queries == 'JSON' else None
					ANSWER = response.json() if queries == 'JSON' else response.text if queries == 'TEXT' else response
					debug_MS(f"(utilities.retrieveContent) === CALLBACK === RETRIES_no : {retries} === STATUS : {response.status_code} || URL : {response.url} || HEADER : {_header(REF, SHARING)} ===")
				except Exception as exc: # No JSON object could be decoded
					failing(f"(utilities.retrieveContent) ERROR - CURRENT_TOKEN - ERROR ##### RETRIES_no : {retries} === URL : {url} === FAILURE : {exc} #####")
					CONTENT = requests.get(f"{BASE_URL}sport/", headers=_header(BASE_URL), allow_redirects=redirects, verify=self.verify_ssl, timeout=10)
					SCAN_REQ = re.compile(r'''</script><script src=["']https://cdn.servustv.com/_next/static/([^/]+)/_ssgManifest.js["']''', re.S).findall(CONTENT.text)
					#SCAN_REQ = re.compile(r'''["']query["']:.*?,["']buildId["']:["']([^"']+)["'],["']assetPrefix["']''', re.S).findall(CONTENT.text)
					if SCAN_REQ:
						NEW_CODING = SCAN_REQ[0].strip()
						addon.setSetting('servus_staticCODE', NEW_CODING)
					elif retries > 1 and not SCAN_REQ:
						retries += 2
						dialog.notification(translation(30521).format('URL'), translation(30524), icon, 12000)
						break
					time.sleep(2)
		debug_MS("═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═ ═")
		return ANSWER
