﻿# -*- coding: utf-8 -*-

from .common import *
from .utilities import Transmission


def mainMenu():
	debug_MS("(navigator.mainMenu) ------------------------------------------------ START = mainMenu -----------------------------------------------")
	ACCESS, CANTON = Transmission().check_FreeToken()
	if CANTON:
		for TITLE, IMG, PATH in [(30601, 'favourites', {'mode': 'listFavorites'}), (30602, 'overviews', {'mode': 'listCategories', 'slug': f"/index.json?geo={CANTON.upper()}", 'name': 'Startseite'}),
			(30603, 'overviews', {'mode': 'listCategories', 'slug': f"/sport-programm.json?geo={CANTON.upper()}", 'name': 'Sport-Programm'}),
			(30604, 'overviews', {'mode': 'listCategories', 'slug': f"/sport.json?geo={CANTON.upper()}", 'name': 'Sport'}), 
			(30605, 'overviews', {'mode': 'listCategories', 'slug': f"/mediathek/p/highlights.json?geo={CANTON.upper()}", 'name': 'Mediathek'}),
			(30606, 'overviews', {'mode': 'listCategories', 'slug': f"/volkskultur/p/die-servus-welt.json?geo={CANTON.upper()}", 'name': 'Servus-Welt'}),
			(30607, 'overviews', {'mode': 'listArchives', 'slug': SERTV_LP1.format('Spielfilme', CANTON.upper(), 'allevideos'), 'name': 'Filme'}),
			(30608, 'overviews', {'mode': 'listBroadcasts', 'slug': f"/volkskultur/p/die-servus-welt.json?geo={CANTON.upper()}", 'name': 'Gerade neu bei Servus TV On'}),
			(30609, 'basesearch', {'mode': 'SearchSERVUS'}), (30610, 'channels', {'mode': 'listChannels'})]:
			addDir(PATH, create_entries({'Title': translation(TITLE), 'Image': f"{artpic}{IMG}.png"}))
		NATION = CANTON.upper().replace('CH', 'SUISSE').replace('AT', translation(30621)).replace('DE', translation(30622)).replace('SUISSE', translation(30623))
		TEXTBOX = translation(30624).format(NATION, MARKET_CODE.upper())
	else: TEXTBOX = translation(30625)
	LAYOUT = translation(30611)+TEXTBOX if textSelection == 0 else TEXTBOX+translation(30611) if textSelection == 1 else TEXTBOX if textSelection == 2 else translation(30611)
	if CANTON and enableADJUSTMENT:
		addDir({'mode': 'aConfigs'}, create_entries({'Title': LAYOUT, 'Image': f"https://flagcdn.com/256x192/{CANTON}.png"}), False)
		if plugin_operate('inputstream.adaptive'):
			addDir({'mode': 'iConfigs'}, create_entries({'Title': translation(30612), 'Image': f"{artpic}settings.png"}), False)
	else: addDir({'mode': 'blankFUNC', 'url': '00'}, create_entries({'Title': TEXTBOX, 'Image': f"https://flagcdn.com/256x192/{CANTON if CANTON else 'va'}.png"}), False)
	xbmcplugin.endOfDirectory(ADDON_HANDLE, succeeded=True, cacheToDisc=False)

def unsubscribe():
	debug_MS("(navigator.unsubscribe) -------------------------------------------------- START = unsubscribe --------------------------------------------------")
	if xbmcvfs.exists(tempSERV) and os.path.isdir(tempSERV):
		debug_MS("(navigator.unsubscribe[1]) XXXXX USER FORCE REMOVING TOKEN - DELETE TOKENFILE XXXXX")
		shutil.rmtree(tempSERV, ignore_errors=True)
		return dialog.notification(translation(30530), translation(30531), icon, 10000)
	return dialog.ok(addon_id, translation(30503))

def message(NOTE):
	return dialog.ok(addon_name, translation(30504).format(re.sub(r'(\[.*?\]|  \(demnächst\)|  \(shortly\))', '', NOTE)))

def listCategories(SLUG, NAME):# https://www.servustv.com/_next/data/-oFqpH0I2ceCH2t61zSIl/index.json
	debug_MS("(navigator.listCategories) ------------------------------------------------ START = listCategories -----------------------------------------------")
	debug_MS(f"(navigator.listCategories) ### SLUG = {SLUG} ### NAME = {NAME} ###")
	(ACCESS, CANTON), (INSTANCE, FOUND, COUNTER), (BLOCKLIST, STARTLIST, LIVEOPS) = Transmission().check_FreeToken(), (0 for _ in range(3)), ({} for _ in range(3))
	GEOLOC, OVERVIEW, FIRST, LASTS = CANTON.upper(), Transmission().retrieveContent(SLUG, REF=BASE_URL), ['rbmh/hero-block', 'rbmh/posts-grid', 'rbmh/promo'], ['rbmh/hero-block', 'rbmh/posts-grid', 'stv/selected-shows']
	DATA_ONE = OVERVIEW['pageProps'] if OVERVIEW not in ['', None] and OVERVIEW.get('pageProps', '') else []
	if DATA_ONE and DATA_ONE.get('liveEvents', '') and DATA_ONE['liveEvents'].get('list', ''):
		INSTANCE, BLOCKLIST, STARTLIST, GEOLOC = 1, DATA_ONE['liveEvents'].get('list', []), DATA_ONE['liveEvents'].get('subCategories', []), DATA_ONE.get('geo', CANTON.upper())
		LIVEOPS = DATA_ONE['siteSettings']['liveopsSchedules'][GEOLOC] if DATA_ONE['siteSettings'].get('liveopsSchedules', '') and DATA_ONE['siteSettings']['liveopsSchedules'].get(GEOLOC, '') else {}
	elif DATA_ONE and DATA_ONE.get('page', '') and DATA_ONE['page'].get('blocks', ''):
		INSTANCE, BLOCKLIST, STARTLIST, GEOLOC = 2, DATA_ONE['page'].get('blocks', []), DATA_ONE['page'], DATA_ONE.get('geo', CANTON.upper())
	elif DATA_ONE and DATA_ONE.get('data', '') and DATA_ONE['data'].get('blocks', ''):
		INSTANCE, BLOCKLIST, STARTLIST, GEOLOC = 3, DATA_ONE['data'].get('blocks', []), DATA_ONE['data'], DATA_ONE.get('geo', CANTON.upper())
	if INSTANCE == 1 and NAME == 'Sport-Programm' and STARTLIST and len(STARTLIST) > 0:
		for sports in STARTLIST:
			FOUND += 1
			debug_MS(f"(navigator.listCategories[1]) ##### COUNTER : {FOUND} || SUBCATEGORY : {sports} || SLUG : {SLUG} #####")
			addDir({'mode': 'listCategories', 'slug': SLUG, 'name': sports}, create_entries({'Title': sports, 'Image': f"{artpic}archives.png"}), higher=True)
		debug_MS("---------------------------------------------")
	for item in BLOCKLIST:
		(thumb, poster), (code, banner), fanart = (f"{artpic}overviews.png" for _ in range(2)), (None for _ in range(2)), defaultFanart
		DETECT_UNO = True if item.get('date', '') and item.get('category', '') and SLUG.count('/') < 3 else False
		DETECT_DUE = True if item.get('blockName', '') in FIRST and SLUG.count('/') < 3 else False
		DETECT_TRE = True if ((item.get('blockName', '') in FIRST and NAME == 'Mediathek') or (item.get('blockName', '') in LASTS)) and SLUG.count('/') >= 3 else False
		if INSTANCE == 1 and item.get('event', []) and DETECT_UNO:
			if NAME != 'Sport-Programm' and NAME != item.get('subcategory', 'Unknown'): continue # Filtering entries, if only one Category is selected
			each, folder, (ACTION, FETCH_UNO) = create_substances(item, LIVEOPS, f"?geo={GEOLOC}", 'SPORT'), True, ({} for _ in range(2))
			# [ident=0, transfer=1, species=2, playable=3, name=4, seriesname=5, tagline=6, desc=7, duration=8, season=9, episode=10]
			# [note_1=11, note_2=12, note_3=13, note_4=14, begins=15, aired=16, genre=17, mpaa=18, thumb=19, poster=20, banner=21, fanart=22]
			FOUND += 1
			PLOT = f"{each[11]}{each[12]}{each[13]}{each[14]}{each[7]}"
			FETCHING = {'Cid': each[0], 'Link': each[1], 'Species': each[2], 'Title': each[4], 'Tagline': each[6], 'Plot': PLOT, 'Season': each[9], 'Episode': each[10], \
				'Date': each[15], 'Aired': each[16], 'Genre': each[17], 'Mpaa': each[18], 'Image': each[19], 'Poster': each[20], 'Banner': each[21], 'Fanback': each[22]}
			if each[3] is True and each[2] in ['LIVE', 'POST']: # Special-Play if 'playable' and Event in ['LIVE', 'POST']
				folder, ACTION = False, {'mode': 'playVideo', 'url': each[0], 'action': f"EVENT_PLAY@@{each[4]}@@{each[20]}@@{PLOT}@@"}
				FETCH_UNO = {**FETCHING, **{'Mediatype': 'episode'}}
			elif each[3] is False and each[2] in ['TRIM', 'NEXT']: # Message if not 'playable' and Event in ['TRIM', 'NEXT']
				folder, ACTION = False, {'mode': 'newsFUNC', 'slug': re.sub(r'\[/?B\]', '', each[4])}
				FETCH_UNO = FETCHING
			debug_MS(f"(navigator.listCategories[2]) ##### COUNTER : {FOUND} || NAME : {each[4]} || isFOLDER : {folder} || IDD : {each[0]} #####")
			debug_MS(f"(navigator.listCategories[2]) ##### SERIE : {each[5]} || GENRE : {each[17]} || AIRED : {each[16]} || THUMB : {each[19]} #####")
			addDir(ACTION, create_entries(FETCH_UNO), folder, higher=True)
		elif INSTANCE in [2, 3] and item.get('innerBlocks', []) and (DETECT_DUE or DETECT_TRE):
			if not item.get('attrs', '') or any(xc.get('attrs', {}).get('card_label', '') for xc in item.get('innerBlocks', [])): continue # Hide TicketSales, Newsletter-/WhatsApp-Registration
			post_table = list(filter(lambda xp: (xp.get('post', '') and xp.get('attrs', '') and xp['attrs'].get('aspect_ratio', '') == '16-9'), item.get('innerBlocks', [])))
			if DETECT_TRE and post_table: # Show 'Neueste Folge' if available
				for posts in post_table:
					each, folder, (ACTION, FETCH_UNO) = create_substances(posts.get('post', {}), STARTLIST, f"?geo={GEOLOC}"), True, ({} for _ in range(2))
					# [ident=0, transfer=1, species=2, playable=3, name=4, seriesname=5, tagline=6, desc=7, duration=8, season=9, episode=10]
					# [note_1=11, note_2=12, note_3=13, note_4=14, begins=15, aired=16, genre=17, mpaa=18, thumb=19, poster=20, banner=21, fanart=22]
					FOUND, COUNTER = FOUND.__add__(1), COUNTER.__add__(1)
					if COUNTER > 1: continue # Show only the first Video and not other related Entries
					PLOT = f"{each[11]}{each[12]}{each[13]}{each[14]}{each[7]}"
					FETCHING = {'Cid': each[0], 'Link': each[1], 'Species': each[2], 'Title': each[4], 'Tagline': each[6], 'Plot': PLOT, 'Season': each[9], 'Episode': each[10], \
						'Date': each[15], 'Aired': each[16], 'Genre': each[17], 'Mpaa': each[18], 'Image': each[19], 'Poster': each[20], 'Banner': each[21], 'Fanback': each[22]}
					if each[3] is True and each[8] is not None: # Normal-Play if 'playable' and Duration is found
						folder, ACTION = False, {'mode': 'playVideo', 'url': each[0]}
						FETCH_UNO = {**FETCHING, **{'Duration': each[8], 'Mediatype': 'movie', 'Reference': 'Single'}}
					elif each[3] is True and each[2] in ['LIVE', 'POST']: # Special-Play if 'playable' and Event in ['LIVE', 'POST']
						folder, ACTION = False, {'mode': 'playVideo', 'url': each[0], 'action': f"EVENT_PLAY@@{each[4]}@@{each[20]}@@{PLOT}@@"}
						FETCH_UNO = {**FETCHING, **{'Mediatype': 'episode'}}
					else: continue
					debug_MS(f"(navigator.listCategories[3]) ##### COUNTER : {FOUND} || NAME : {each[4]} || isFOLDER : {folder} || IDD : {each[0]} #####")
					debug_MS(f"(navigator.listCategories[3]) ##### PLAYABLE : {each[3]} || DURATION : {each[8]} || GENRE : {each[17]} || AIRED : {each[16]} #####")
					debug_MS(f"(navigator.listCategories[3]) ##### SERIE : {each[5]} || SEASON : {each[9]} || EPISODE : {each[10]} || THUMB : {each[19]} #####")
					debug_MS("---------------------------------------------")
					addDir(ACTION, create_entries(FETCH_UNO), folder, higher=True)
			else: # Show all other entries
				if not item['attrs'].get('heading', ''): title = name = '[COLOR lime]EMPFEHLUNGEN[/COLOR]'
				else: title, name = item['attrs']['heading'].replace('Empfehlungen', '[COLOR lime]EMPFEHLUNGEN[/COLOR]'), item['attrs']['heading']
				if 'LIVE-KANÄLE' in name.upper(): continue # Hide Category 'Live-Kanäle'
				FOUND += 1
				if item.get('innerBlocks', {})[0].get('post', '') and item['innerBlocks'][0]['post'].get('stv_id', ''):
					code = item['innerBlocks'][0]['post']['stv_id'].strip()
				elif item.get('innerBlocks', {})[0].get('attrs', '') and item['innerBlocks'][0]['attrs'].get('post_link', ''):
					code = item['innerBlocks'][0]['attrs']['post_link'].split('/')[-2].strip().upper()
				if code: thumb, poster, banner, fanart = get_Picture(code, 'square', '750'), get_Picture(code, 'portrait', '500'), get_Picture(code, 'banner', '750'), get_Picture(code, 'landscape', '1200')
				plot_one = f'[B][COLOR gold]{title}[/COLOR][/B]'
				plot_two = (STARTLIST.get('stv_long_description', '') or STARTLIST.get('stv_short_description', '') or '')
				full_one, genre_one = f"{plot_one}[CR][CR]{plot_two}" if plot_two != "" else plot_one, (STARTLIST.get('vertical', '') or STARTLIST.get('stv_topic_name', ''))
				FETCH_DUE = create_entries({'Title': title, 'Plot': full_one, 'Genre': genre_one, 'Image': thumb, 'Poster': poster, 'Banner': banner, 'Fanback': fanart})
				debug_MS(f"(navigator.listCategories[4]) ##### COUNTER : {FOUND} || NAME : {name} || SLUG : {SLUG} #####")
				addDir({'mode': 'listBroadcasts', 'slug': SLUG, 'name': re.sub(r'\[.*?\]', '', name)}, FETCH_DUE, higher=True)
	if INSTANCE in [2, 3] and DATA_ONE and DATA_ONE.get('initialLibData', '') and DATA_ONE['initialLibData'].get('filters', []): # Show ['allevideos', 'ganzesendungen', 'einzelbeitrage', 'ubertragungen'] if available
		other_table = list(filter(lambda xo: (xo.get('value', '') in ['allevideos', 'ganzesendungen', 'einzelbeitrage', 'ubertragungen'] and xo.get('count', 0) > 0), DATA_ONE['initialLibData'].get('filters', [])))
		if other_table:
			addDir({'mode': 'blankFUNC'}, create_entries({'Title': translation(30631), 'Image': f"{artpic}archives.png"}), False)
			debug_MS("---------------------------------------------")
			for others in other_table:
				FOUND += 1
				serie, label, marker, picture = STARTLIST.get('stv_category_name', ''), others.get('label'), others.get('value'), f"{artpic}archives.png"
				plot_uno, link = f'[B][COLOR gold]{serie}[/COLOR][CR]≡ {label.upper()} ≡[/B]', SERTV_LP1.format(serie, GEOLOC, marker)
				plot_due, oper_tre = (STARTLIST.get('stv_long_description', '') or STARTLIST.get('stv_short_description', '') or ''), 'adding'
				full_uno, genre_uno = f"{plot_uno}[CR][CR]{plot_due}" if plot_due != "" else plot_uno, (STARTLIST.get('vertical', '') or STARTLIST.get('stv_topic_name', ''))
				FETCH_TRE = CONEX_TRE = {'Cid': f"{serie} - {label}", 'Link': link, 'Species': '', 'Title': label, 'Tagline': '', 'Plot': full_uno, \
					'Season': '', 'Episode': '', 'Date': '', 'Aired': '', 'Genre': genre_uno, 'Mpaa': '', 'Image': picture, 'Poster': picture, 'Banner': '', 'Fanback': ''}
				if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
					for snippet in preserve(FAVORIT_FILE):
						if snippet.get('Link') == link: oper_tre = 'skipping'
				debug_MS(f"(navigator.listCategories[5]) ##### COUNTER : {FOUND} || NAME : {serie} || SLUG : {link} #####")
				addDir({'mode': 'listArchives', 'slug': link, 'name': serie}, create_entries(FETCH_TRE), True, CONEX_TRE, oper_tre, True)
	if FOUND == 0:
		failing(f'(navigator.listCategories) ##### NO CATEGORY_LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30527).format(NAME), icon, 10000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listBroadcasts(SLUG, NAME):
	debug_MS("(navigator.listBroadcasts) ------------------------------------------------ START = listBroadcasts -----------------------------------------------")
	debug_MS(f"(navigator.listBroadcasts) ### SLUG = {SLUG} ### NAME = {NAME} ###")
	(ACCESS, CANTON), (INSTANCE, FOUND, topping), (BLOCKLIST, STARTLIST) = Transmission().check_FreeToken(), (0 for _ in range(3)), ({} for _ in range(2))
	GEOLOC, OVERVIEW = CANTON.upper(), Transmission().retrieveContent(SLUG, forcing=True) if SLUG.startswith(SERTV_LP1) else Transmission().retrieveContent(SLUG, REF=BASE_URL)
	DATA_ONE = OVERVIEW['pageProps'] if OVERVIEW not in ['', None] and OVERVIEW.get('pageProps', '') else []
	if DATA_ONE and DATA_ONE.get('page', '') and DATA_ONE['page'].get('blocks', ''):
		INSTANCE, BLOCKLIST, STARTLIST, GEOLOC = 1, DATA_ONE['page'].get('blocks', []), DATA_ONE['page'], DATA_ONE.get('geo', CANTON.upper())
	elif DATA_ONE and DATA_ONE.get('data', '') and DATA_ONE['data'].get('blocks', ''):
		INSTANCE, BLOCKLIST, STARTLIST, GEOLOC = 2, DATA_ONE['data'].get('blocks', []), DATA_ONE['data'], DATA_ONE.get('geo', CANTON.upper())
	for item in BLOCKLIST: # Show only ['rbmh/hero-block', 'rbmh/posts-grid', 'rbmh/promo']
		if item.get('blockName', '') in ['rbmh/hero-block', 'rbmh/posts-grid', 'rbmh/promo', 'stv/selected-shows'] and item.get('innerBlocks', []):
			if (item.get('attrs', '') and item['attrs'].get('heading', '') == NAME) or (item.get('blockName', '') == 'rbmh/hero-block' and NAME == 'EMPFEHLUNGEN'):
				card_table = list(filter(lambda xc: (xc.get('blockName', '') == 'rbmh/basic-promo-card' and xc.get('attrs', '') and xc['attrs'].get('post_link', '') and not xc['attrs'].get('card_label', '') and not xc.get('post', '')), item.get('innerBlocks', [])))
				post_table = list(filter(lambda xp: (xp.get('post', '') and not xp['post'].get('content_entitlements', '')), item.get('innerBlocks', [])))
				for cards in card_table: # Show Folders with 'heading_two' and 'post_link' inside, that not have 'card_label' filled out inside
					FOUND += 1
					name, oper_uno = cards['attrs'].get('heading_two', 'UNKNOWN'), 'adding'
					link = f"{cards['attrs']['post_link'][:-1].strip().replace('https://www.servustv.com', '')}.json?geo={GEOLOC}"
					code = cards['attrs']['post_link'].split('/')[-2].upper()
					thumb, poster, banner, fanart = get_Picture(code, 'square', '750'), get_Picture(code, 'portrait', '500'), get_Picture(code, 'banner', '750'), get_Picture(code, 'landscape', '1200')
					plot_uno = f'[B][COLOR gold]{name}[/COLOR][CR]≡ ÜBERSICHT ≡[/B]'
					plot_due = (STARTLIST.get('stv_long_description', '') or STARTLIST.get('stv_short_description', '') or '')
					full_uno, genre_uno = f"{plot_uno}[CR][CR]{plot_due}" if plot_due != "" else plot_uno, NAME
					FETCH_UNO = CONEX_UNO = {'Cid': name, 'Link': link, 'Species': '', 'Title': name, 'Tagline': '', 'Plot': full_uno, 'Season': '', 'Episode': '', \
						'Date': '', 'Aired': '', 'Genre': genre_uno, 'Mpaa': '', 'Image': thumb, 'Poster': poster, 'Banner': banner, 'Fanback': fanart}
					if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
						for gobbet in preserve(FAVORIT_FILE):
							if gobbet.get('Link') == link: oper_uno = 'skipping'
					debug_MS(f"(navigator.listBroadcasts[1]) ##### COUNTER : {FOUND} || NAME : {name} || SLUG : {link} || THUMB : {thumb} #####")
					addDir({'mode': 'listCategories', 'slug': link, 'name': name}, create_entries(FETCH_UNO), True, CONEX_UNO, oper_uno, True)
				for posts in post_table: # Show all Items that are in 'post', that not have TicketSales (pay-per-view) inside
					each, folder, oper_due, (ACTION, FETCH_DUE, CONEX_DUE) = create_substances(posts.get('post', {}), STARTLIST, f"?geo={GEOLOC}"), True, 'skipping', ({} for _ in range(3))
					# [ident=0, transfer=1, species=2, playable=3, name=4, seriesname=5, tagline=6, desc=7, duration=8, season=9, episode=10]
					# [note_1=11, note_2=12, note_3=13, note_4=14, begins=15, aired=16, genre=17, mpaa=18, thumb=19, poster=20, banner=21, fanart=22]
					PLOT = f"{each[11]}{each[12]}{each[13]}{each[14]}{each[7]}"
					FETCHING = {'Cid': each[0], 'Link': each[1], 'Species': each[2], 'Title': each[4], 'Tagline': each[6], 'Plot': PLOT, 'Season': each[9], 'Episode': each[10], \
						'Date': each[15], 'Aired': each[16], 'Genre': each[17], 'Mpaa': each[18], 'Image': each[19], 'Poster': each[20], 'Banner': each[21], 'Fanback': each[22]}
					if each[3] is True and each[8] is not None: # Normal-Play if 'playable' and Duration is found
						folder, topping, ACTION = False, topping.__add__(1), {'mode': 'playVideo', 'url': each[0]}
						FETCH_DUE = {**FETCHING, **{'Duration': each[8], 'Mediatype': 'movie', 'Reference': 'Single'}}
					elif each[3] is True and each[2] in ['LIVE', 'POST']: # Special-Play if 'playable' and Event in ['LIVE', 'POST']
						folder, topping, ACTION = False, topping.__add__(1), {'mode': 'playVideo', 'url': each[0], 'action': f"EVENT_PLAY@@{each[4]}@@{each[20]}@@{PLOT}@@"}
						FETCH_DUE = {**FETCHING, **{'Mediatype': 'episode'}}
					elif each[3] is False and each[2] in ['TRIM', 'NEXT'] and each[8] is None: # Message or Folder if not 'playable' and Duration is not found
						folder, topping, ACTION = False, topping.__add__(1), {'mode': 'newsFUNC', 'slug': re.sub(r'\[/?B\]', '', each[4])}
						FETCH_DUE = FETCHING
					elif each[3] is False and each[2] not in ['TRIM', 'NEXT'] and each[8] is None:
						folder, oper_due, ACTION = True, 'adding', {'mode': 'listCategories', 'slug': each[1], 'name': each[4]}
						FETCH_DUE = CONEX_DUE = {**FETCHING, **{'Cid': each[4], 'Plot': f"[B]{re.sub(r'yellow', 'gold', each[11])}≡ ÜBERSICHT ≡[/B][CR]{each[12]}{each[13]}{each[14]}{each[7]}"}}
						if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
							for snippet in preserve(FAVORIT_FILE):
								if snippet.get('Link') == each[1]: oper_due = 'skipping'
					else: continue
					FOUND += 1
					if FOUND == topping:
						for method in getSorting(): xbmcplugin.addSortMethod(ADDON_HANDLE, method)
					debug_MS(f"(navigator.listBroadcasts[2]) ##### COUNTER : {FOUND} || NAME : {each[4]} || isFOLDER : {folder} || IDD : {each[0]} #####")
					debug_MS(f"(navigator.listBroadcasts[2]) ##### PLAYABLE : {each[3]} || DURATION : {each[8]} || GENRE : {each[17]} || AIRED : {each[16]} #####")
					debug_MS(f"(navigator.listBroadcasts[2]) ##### SERIE : {each[5]} || SEASON : {each[9]} || EPISODE : {each[10]} || THUMB : {each[19]} #####")
					debug_MS("---------------------------------------------")
					addDir(ACTION, create_entries(FETCH_DUE), folder, CONEX_DUE, oper_due, True)
	if FOUND == 0:
		failing(f'(navigator.listBroadcasts) ##### NO BROADCAST_LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30527).format(NAME), icon, 10000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listArchives(SLUG, NAME, PAGE, LIMIT=12): # https://www.servustv.com/api/v1/media-asset/landing-page-archive/?category=Spielfilme&currentPage=1&geo=DE&newCurrentFilter=allevideos
	debug_MS("(navigator.listArchives) ------------------------------------------------ START = listArchives -----------------------------------------------")
	debug_MS(f"(navigator.listArchives) ### SLUG = {SLUG} ### NAME = {NAME} ### ACTUAL_COUNT = {int(PAGE)*int(LIMIT)} ###")
	FOUND, DATA_ONE = 0, Transmission().retrieveContent(SLUG, forcing=True)
	if DATA_ONE not in ['', None] and DATA_ONE.get('items', []):
		for item in DATA_ONE.get('items', []):
			each, folder, (ACTION, FETCH_UNO) = create_substances(item), True, ({} for _ in range(2))
			# [ident=0, transfer=1, species=2, playable=3, name=4, seriesname=5, tagline=6, desc=7, duration=8, season=9, episode=10]
			# [note_1=11, note_2=12, note_3=13, note_4=14, begins=15, aired=16, genre=17, mpaa=18, thumb=19, poster=20, banner=21, fanart=22]
			FOUND += 1
			PLOT = f"{each[11]}{each[12]}{each[13]}{each[14]}{each[7]}"
			FETCHING = {'Cid': each[0], 'Link': each[1], 'Species': each[2], 'Title': each[4], 'Tagline': each[6], 'Plot': PLOT, 'Season': each[9], 'Episode': each[10], \
				'Date': each[15], 'Aired': each[16], 'Genre': each[17], 'Mpaa': each[18], 'Image': each[19], 'Poster': each[20], 'Banner': each[21], 'Fanback': each[22]}
			if each[3] is True and each[8] is not None: # Normal-Play if 'playable' and Duration is found:
				folder, ACTION = False, {'mode': 'playVideo', 'url': each[0]}
				FETCH_UNO = {**FETCHING, **{'Duration': each[8], 'Mediatype': 'movie', 'Reference': 'Single'}}
			elif each[3] is False or each[8] is None: # Message if not 'playable' or Duration is not found
				folder, ACTION = False, {'mode': 'newsFUNC', 'slug': re.sub(r'\[/?B\]', '', each[4])}
				FETCH_UNO = FETCHING
			if not folder:
				for method in getSorting(): xbmcplugin.addSortMethod(ADDON_HANDLE, method)
			debug_MS(f"(navigator.listArchives[1]) ##### COUNTER : {FOUND} || NAME : {each[4]} || isFOLDER : {folder} || IDD : {each[0]} #####")
			debug_MS(f"(navigator.listArchives[1]) ##### PLAYABLE : {each[3]} || DURATION : {each[8]} || GENRE : {each[17]} || AIRED : {each[16]} #####")
			debug_MS(f"(navigator.listArchives[1]) ##### SERIE : {each[5]} || SEASON : {each[9]} || EPISODE : {each[10]} || THUMB : {each[19]} #####")
			debug_MS("---------------------------------------------")
			addDir(ACTION, create_entries(FETCH_UNO), folder, higher=True)
	if FOUND == 0:
		failing(f'(navigator.listArchives) ##### NO ARCHIVE_LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30527).format(NAME), icon, 10000)
	elif str(DATA_ONE.get('count')).isdecimal() and int(DATA_ONE['count']) > int(PAGE)*int(LIMIT):
		debug_MS(f"(navigator.listArchives[2]) PAGES ### NEXT_COUNT : {(int(PAGE)+1)*int(LIMIT)} from TOTAL_COUNT : {int(DATA_ONE['count'])} ###")
		FETCH_DUE = create_entries({'Title': translation(30632).format(int(PAGE)+1), 'Image': f"{artpic}nextpage.png"})
		addDir({'mode': 'listArchives', 'slug': re.sub(r'currentPage=[0-9]+', f'currentPage={int(PAGE)+1}', SLUG), 'name': NAME, 'page': int(PAGE)+1}, FETCH_DUE)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def create_substances(rsx, ABACK={}, SUFFIX="", SECTOR='BLANK'):
	(note_1, note_2, note_3, note_4, description), (thumb, poster), fanart = ("" for _ in range(5)), (f"{artpic}overviews.png" for _ in range(2)), defaultFanart
	TRACE, tagline, duration, season, episode, startdate, aired, begins, LOCALends, endsdate, startlive, endslive, mpaa, genre, banner = (None for _ in range(15))
	if SECTOR == 'SPORT':
		genre, rsx = rsx.get('category', 'Sport'), rsx['event']
		mores = next(filter(lambda xa: xa.get('asset_id', '') == rsx.get('id', ''), ABACK), None)
		st_code, st_link, st_name, st_serie, short_plot, st_play = 'id', 'link', 'teaserTitle', 'title', 'description', 'isLive'
		st_starting = mores['start'] if mores and str(mores.get('start')).isdecimal() else None
		st_stopping = mores['stop'] if mores and str(mores.get('stop')).isdecimal() else None
		date_starts = [rsx['startTime'], 'DATETIME'] if rsx.get('startTime', '') and str(rsx['startTime'])[:4].isdecimal() else None
	elif SECTOR == 'SEARCH':
		genre = rsx['permalink'].split('/', 1)[1].split('/', 1)[0].title() if rsx.get('permalink', '') else None
		st_code, st_link, st_name, st_serie, short_plot, st_play, st_starting, st_stopping = 'id', 'permalink', 'title', 'category', 'description', 'has_binary', None, None
		duration = int(rsx['duration']) // 1000 if str(rsx.get('duration')).isdecimal() and int(rsx['duration']) != 0 else None
		date_starts = [rsx['sunrise'], 'DATETIME'] if rsx.get('sunrise', '') and str(rsx['sunrise'])[:4].isdecimal() else None
	else:
		genre = (rsx.get('vertical', '') or rsx.get('stv_topic_name', '') or ABACK.get('vertical', '') or ABACK.get('stv_topic_name', ''))
		st_code, st_link, st_name, st_serie, short_plot, st_play = 'stv_id', 'link', 'stv_teaser_title', 'stv_category_name', 'stv_short_description', 'stv_has_binary'
		duration = int(rsx['stv_duration']['raw']) // 1000 if rsx.get('stv_duration', '') and str(rsx['stv_duration'].get('raw')).isdecimal() and int(rsx['stv_duration']['raw']) != 0 else None
		st_starting = rsx['stv_live_schedules'][0]['start_timestamp'] if rsx.get('stv_live_schedules', '') and str(rsx.get('stv_live_schedules', {})[0].get('start_timestamp')).isdecimal() else None
		st_stopping = rsx['stv_live_schedules'][0]['stop_timestamp'] if rsx.get('stv_live_schedules', '') and str(rsx.get('stv_live_schedules', {})[0].get('stop_timestamp')).isdecimal() else None
		date_starts = [rsx['stv_sunrise']['raw'], 'EPOCHTIME'] if rsx.get('stv_sunrise', '') and str(rsx['stv_sunrise'].get('raw')).isdecimal() else None
	ident = rsx[st_code].strip() if rsx.get(st_code, '') else '00'
	transfer = f"{rsx[st_link][:-1].strip().replace('https://www.servustv.com', '')}.json{SUFFIX}" if rsx.get(st_link, '') else 'Unknown-Link'
	curtness = (rsx.get('stv_short_title', '') or rsx.get(st_name, ''))
	seriesname = rsx.get(st_serie, None) if rsx.get(st_serie, '') != 'Spielfilme' else None
	if seriesname: note_1 = translation(32101).format(seriesname)
	if rsx.get('stv_long_description', '') or rsx.get(short_plot, ''):
		if rsx.get('stv_long_description', '') and len(rsx['stv_long_description']) > 10:
			TRACE = rsx['stv_long_description']
		if TRACE is None and rsx.get(short_plot, '') and len(rsx[short_plot]) > 10:
			TRACE = rsx[short_plot]
	if TRACE is None and isinstance(ABACK, dict) and (ABACK.get('stv_long_description', '') or ABACK.get('stv_short_description', '')):
		if ABACK.get('stv_long_description', '') and len(ABACK['stv_long_description']) > 10:
			TRACE = ABACK['stv_long_description']
		if TRACE is None and ABACK.get('stv_short_description', '') and len(ABACK['stv_short_description']) > 10:
			TRACE = ABACK['stv_short_description']
	if TRACE: description = TRACE
	if rsx.get('stv_category_name', '') == 'Spielfilme' and rsx.get('stv_teaser_description', None) is not None and str(rsx.get('stv_teaser_description')) not in description:
		tagline = rsx['stv_teaser_description']
	if SECTOR in ['SPORT', 'SEARCH']: title = curtness
	else:
		title = curtness if (rsx['title'].get('rendered', '') and any(ve in rsx['title']['rendered'] for ve in ['Episode', 'Folge']) and not 'Staffel' in rsx['title']['rendered']) or (not rsx['title'].get('rendered', '')) else rsx['title']['rendered']
		matchSE = re.search('(Staffel:? |S)(\d+)', rsx['title'].get('rendered', ''))
		season = f"{int(matchSE.group(2)):02}" if matchSE and int(matchSE.group(2)) != 0 else None
		matchEP = re.search('(Episode:? |Folge:? )(\d+)', rsx['title'].get('rendered', ''))
		episode = f"{int(matchEP.group(2)):02}" if matchEP and int(matchEP.group(2)) != 0 else None
	if season and episode: note_2 = translation(32102).format(season, episode)
	elif season is None and episode: note_2 = translation(32103).format(episode)
	if st_starting: # 1752595200000 = Starts in Milliseconds
		EVENTstart = get_CentralTime(datetime(1970,1,1) + timedelta(milliseconds=st_starting))
		startlive = EVENTstart.strftime('%d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
	if st_stopping: # 1752606000000 = Ends in Milliseconds
		EVENTends = get_CentralTime(datetime(1970,1,1) + timedelta(milliseconds=st_stopping))
		endslive = EVENTends.strftime('%d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
	if ((SECTOR == 'SPORT' and startlive is None) or (SECTOR in ['BLANK', 'SEARCH'])) and date_starts: # 1752595200000 = Starts in Milliseconds // 2025-07-15T16:00:00 = Starts in Datetime-Format
		LOCALstart = get_CentralTime(date_starts[0], date_starts[1]) if SECTOR in ['SPORT', 'SEARCH'] else get_CentralTime(datetime(1970,1,1) + timedelta(milliseconds=date_starts[0]))
		EVENTstart, st_clocking = LOCALstart if SECTOR == 'SPORT' else None, LOCALstart.strftime('%d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
		startlive, startdate = st_clocking if SECTOR == 'SPORT' else startlive, st_clocking if SECTOR in ['BLANK', 'SEARCH'] else None
		aired = LOCALstart.strftime('%d.%m.%Y') # FirstAired
		begins = LOCALstart.strftime('%Y-%m-%dT%H:%M') if KODI_ov20 else LOCALstart.strftime('%d.%m.%Y') # 2023-03-09T12:30:00 = NEWFORMAT // 09.03.2023 = OLDFORMAT
		if startdate and startdate.startswith(('31.12.99', '01.01.00')): startdate = aired = begins = None
	if SECTOR == 'BLANK' and rsx.get('stv_sunset', '') and str(rsx['stv_sunset'].get('raw')).isdecimal(): # 1752606000000 = Ends in Milliseconds
		LOCALends = get_CentralTime(datetime(1970,1,1) + timedelta(milliseconds=rsx['stv_sunset']['raw']))
		endsdate = LOCALends.strftime('%d{0}%m{0}%y {1} %H{2}%M').format('.', '•', ':')
		if endsdate.startswith(('31.12.99', '01.01.00')): endsdate = None
	species = rsx.get('content_type', '') if startlive is None else 'NEXT'
	playable = rsx.get(st_play, False)
	votably = curtness if curtness != "" and seriesname else title
	if SECTOR == 'SPORT' and startlive and playable is True and (datetime.now() + timedelta(minutes=30)) > EVENTstart: # Today plus 30 Minutes is greater than Event-Start
		title, species = translation(32104).format(votably), 'LIVE'
	elif SECTOR == 'BLANK' and startdate and endslive and datetime.now() > LOCALstart and datetime.now() < EVENTends: # Toda is greater than Local-Start and Today is smaller than Event-End
		title, playable, species = translation(32104).format(votably), True, 'LIVE' # Today is greater than Local-Start and Today is smaller than Local-End
	if ((SECTOR == 'SPORT' and startlive and endslive and (datetime.now() + timedelta(minutes=5)) > EVENTstart and datetime.now() < EVENTends) or \
		(SECTOR == 'BLANK' and startlive and startdate and endsdate and datetime.now() > LOCALstart and datetime.now() < LOCALends)) and transfer != 'Unknown-Link' and playable is False:
		published, edited, version = playChecker(transfer)
		if published and edited == 'live' and version.upper()[:4] == 'LIVE': title, playable, species = translation(32104).format(votably), True, 'LIVE'
		elif published and edited == 'post' and version.upper()[:6] == 'REPLAY': title, playable, species = translation(32105).format(votably), True, 'POST'
		elif not published and edited == 'trim' and version.upper()[:5] in ['AWAIT', 'PAST ']: title, playable, species = translation(32106).format(votably), False, 'TRIM'
	if startlive and playable is False and ((SECTOR == 'SPORT' and (datetime.now() - timedelta(minutes=5)) < EVENTstart < (datetime.now() + timedelta(days=5))) or \
		(SECTOR == 'BLANK' and startdate and datetime.now() < LOCALstart < (datetime.now() + timedelta(days=5)))):
		title, species = translation(32107).format(votably), 'NEXT' # Today is smaller as Local-Start and Local-Start is smaller than Today plus 5 Days in future
	if SECTOR == 'BLANK' and startdate and startlive is None and playable is True and datetime.now() < LOCALstart: duration, playable = None, False
	if startdate and endsdate: note_3 = translation(32108).format(startdate, endsdate)
	elif startdate and endsdate is None: note_3 = translation(32109).format(startdate)
	if startlive and endslive: note_4 = translation(32110).format(startlive, endslive)
	elif startlive and endslive is None: note_4 = translation(32111).format(startlive)
	if SECTOR == 'SPORT' and seriesname and startlive is None and description != "": note_4 = '[CR]'
	elif SECTOR in ['BLANK', 'SEARCH'] and seriesname and startdate is None and endsdate is None and description != "": note_3 = '[CR]'
	if genre not in ['', None]: genre = genre.replace('Bike', 'Radsport').replace('Fussball', 'Fußball')
	if str(rsx.get('stv_maturity_rating')) not in ['None', '0', 'nicht definiert']:
		mpaa = str(rsx['stv_maturity_rating'])
	if ident != '00': thumb, poster, banner, fanart = get_Picture(ident, 'square', '750'), get_Picture(ident, 'portrait', '500'), get_Picture(ident, 'banner', '750'), get_Picture(ident, 'landscape', '1200')
	return [ident, transfer, species, playable, title, seriesname, tagline, description, duration, season, episode, note_1, note_2, note_3, note_4, begins, aired, genre, mpaa, thumb, poster, banner, fanart]

def playChecker(TARGET): # Sometimes 'Replay' not shown as playable, so make a special-request for the entry
	debug_MS("(navigator.playChecker) ------------------------------------------------ START = playChecker -----------------------------------------------")
	DATA_LOOK, active, status, notice = Transmission().retrieveContent(TARGET, REF=BASE_URL), False, 'unknown', 'unknown'
	if DATA_LOOK not in ['', None] and DATA_LOOK.get('pageProps', '') and DATA_LOOK['pageProps'].get('cuetagData', ''): # https://www.servustv.com/_next/data/vTZxe0zrIQYgvkvSJgbfl/sport/v/aaj13u6sb08yjld3wks7.json
		cuetag = DATA_LOOK['pageProps']['cuetagData']
		active = True if cuetag.get('player', '') and cuetag['player'].get('active', False) is True else False
		status = cuetag['status']['code'] if cuetag.get('status', '') and cuetag['status'].get('code', '') else 'unknown'
		notice = cuetag['status']['message'] if cuetag.get('status', '') and cuetag['status'].get('message', '') else 'unknown'
	debug_MS(f"(navigator.playChecker[1]) ~~~~~~~~ ACTIVE : {active} || STATUS : {status} || NOTICE : {notice} ~~~~~~~~")
	return (active, status, notice)

def SearchSERVUS(SLUG=None): # https://www.servustv.com/_next/data/vTZxe0zrIQYgvkvSJgbfl/search/meer%20gef%C3%BChl/alle-videos/1.json
	debug_MS("(navigator.SearchSERVUS) ------------------------------------------------ START = SearchSERVUS -----------------------------------------------")
	PAGE_NUMBER, NEXT_PAGE, EPISODES, FOUND, (ACCESS, CANTON) = 1, None, [], 0, Transmission().check_FreeToken()
	keyword = preserve(SEARCH_FILE, 'TEXT') if xbmcvfs.exists(SEARCH_FILE) else None
	if xbmc.getInfoLabel('Container.FolderPath') == HOST_AND_PATH: # !!! this hack is necessary to prevent KODI from opening the input mask all the time !!!
		keyword = dialog.input(translation(30633), type=xbmcgui.INPUT_ALPHANUM, autoclose=15000)
		if keyword: preserve(SEARCH_FILE, 'TEXT', keyword)
	if keyword: SLUG = f"/search/{quote(keyword)}/alle-videos/1.json"
	while PAGE_NUMBER > 0 and SLUG:
		DATA_ONE = Transmission().retrieveContent(SLUG, REF=BASE_URL) if PAGE_NUMBER == 1 else Transmission().retrieveContent(NEXT_PAGE, REF=BASE_URL)
		if DATA_ONE not in ['', None] and DATA_ONE.get('pageProps', '') and DATA_ONE['pageProps'].get('items', []):
			for elem in DATA_ONE['pageProps'].get('items', []):
				EPISODES.append(elem) if str(elem.get('duration')).isdecimal() and int(elem['duration']) != 0 else []
		if DATA_ONE not in ['', None] and DATA_ONE.get('pageProps', '') and DATA_ONE['pageProps'].get('filters', []): # Show ['alle-videos', 'ganze-sendungen', 'einzelbeitrage', 'ubertragungen'] if available
			VIDEOS = next(filter(lambda pav: pav.get('value', '') == 'alle-videos' and pav.get('count', 0) > 0, DATA_ONE['pageProps'].get('filters', [])), None)
			if VIDEOS and str(VIDEOS.get('count')).isdecimal() and int(VIDEOS['count']) > int(PAGE_NUMBER)*12 and int(PAGE_NUMBER) <= 4:
				PAGE_NUMBER += 1 # Get maximum 5 Pages for Search-Results (Entries are limited to a maximum of 12)
				NEXT_PAGE = re.sub(r'alle-videos/[0-9]+.json', f'alle-videos/{int(PAGE_NUMBER)}.json', SLUG)
				debug_MS(f"(navigator.SearchSERVUS[1]) PAGES ### NOW GET NEXTPAGE : {NEXT_PAGE} ###")
			else: break
		else: break
	for item in sorted(EPISODES, key=lambda xev: xev.get('sunrise', '2020-01-01T00:01:00'), reverse=True):
		each = create_substances(item, SECTOR='SEARCH')
		# [ident=0, transfer=1, species=2, playable=3, name=4, seriesname=5, tagline=6, desc=7, duration=8, season=9, episode=10]
		# [note_1=11, note_2=12, note_3=13, note_4=14, begins=15, aired=16, genre=17, mpaa=18, thumb=19, poster=20, banner=21, fanart=22]
		FETCH_UNO = {'Cid': each[0], 'Link': each[1], 'Species': each[2], 'Title': each[4], 'Tagline': each[6], 'Plot': f"{each[11]}{each[13]}{each[7]}", \
			'Duration': each[8], 'Season': each[9], 'Episode': each[10], 'Date': each[15], 'Aired': each[16], 'Genre': each[17], 'Mpaa': each[18], \
			'Mediatype': 'movie', 'Image': each[19], 'Poster': each[20], 'Banner': each[21], 'Fanback': each[22], 'Reference': 'Single'}
		FOUND += 1
		debug_MS(f"(navigator.SearchSERVUS[1]) ##### COUNTER : {FOUND} || NAME : {each[4]} || SERIE : {each[5]} || IDD : {each[0]} #####")
		debug_MS(f"(navigator.SearchSERVUS[1]) ##### DURATION : {each[8]} || GENRE : {each[17]} || AIRED : {each[16]} || THUMB : {each[19]} #####")
		debug_MS("---------------------------------------------")
		addDir({'mode': 'playVideo', 'url': each[0]}, create_entries(FETCH_UNO), False, higher=True)
	if FOUND == 0:
		failing(f'(navigator.SearchSERVUS) ##### NO SEARCH_LIST - NO ENTRY FOR: "{keyword}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(keyword), icon, 10000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listChannels(): # https://dms.redbull.tv/v5/destination/stv/PNEZ060SSZGUI2L/personal_computer/http/at/de_AT/playlist.m3u8
	debug_MS("(navigator.listChannels) ------------------------------------------------ START = listChannels -----------------------------------------------")
	CHANNELS, CONNECTS, FOUND , (ACCESS, CANTON) = [], [], 0, Transmission().check_FreeToken()
	if ACCESS: # https://tv-api.redbull.com/collections/v5/stv/de_DE/de/6e6475bc-d2f2-4593-b95f-ed0a74206c62
		DATA_ONE = Transmission().retrieveContent(SERTV_AP5.format('collections', CANTON.upper(), CANTON.lower(), '6e6475bc-d2f2-4593-b95f-ed0a74206c62'), forcing=True)
		for elem in DATA_ONE.get('cards', []):
			st_name, st_code, st_desc = elem['title'].strip(), elem['id'].strip(), (elem.get('short_description', '') or '')
			st_video = f"{SERTV_HLS}destination/stv/{st_code}/personal_computer/http/{CANTON.lower()}/de_{CANTON.upper()}/playlist.m3u8"
			CHANNELS.append({'name': st_name, 'code': st_code, 'video': st_video, 'desc': st_desc.strip(), 'thumb': get_Picture(st_code, 'portrait', '500')})
		for CHAN in CHANNELS: # https://tv-api.redbull.com/guides/v5/stv/de_DE/de/PNCYSSQEAC4U7BR?complete=false / EPG for ON Channels
			debug_MS(f"(navigator.listChannels[1]) ##### TITLE : {CHAN['name']} || CODE : {CHAN['code']} || STREAM : {CHAN['video']} #####")
			stories, DATA_TWO = "", Transmission().retrieveContent(SERTV_AP5.format('guides', CANTON.upper(), CANTON.lower(), f"{CHAN['code']}?complet=false"), queries='TRACK', raising=False, forcing=True)
			if DATA_TWO.status_code == 403: continue # Wintersport On is blocked in Switzerland : Error 403
			elif DATA_TWO.status_code == 404: # More Than Sports : Error 404 = No EPG available
				CONNECTS.append([CHAN['name'], CHAN['code'], CHAN['video'], translation(30641), CHAN['name'], 'FAST - STREAM', translation(30642)])
			else:
				for item in DATA_TWO.json().get('cards', [])[:6]:
					debug_MS(f"(navigator.listChannels[2]) xxxxx ITEM-02 : {item} xxxxx")
					startTIMES, description, exsin = None, "", '\r\n'
					if item.get('start_time', '') and str(item['start_time'])[:4].isdecimal():
						LOCALstart = get_CentralTime(item['start_time'], 'DATETIME')
						startTIMES = LOCALstart.strftime('%d{0}%m{0}%Y {1} %H{2}%M').format('.', '•', ':')
						if startTIMES.startswith(('01.01.2000', '01.01.2100')): startTIMES = translation(30641)
					if item.get('end_time', '') and str(item['end_time'])[:4].isdecimal():
						LOCALends = get_CentralTime(item['end_time'], 'DATETIME')
						if not str(LOCALends).startswith(('2000', '2100')) and LOCALends < datetime.now(): continue
					FOUND += 1
					name = item['subheading'].strip() if item.get('subheading', '') else item['title'].strip()
					epis_check = item['title'].strip() if item.get('title', '') and item['title'].strip().lower() != name.lower() else 'FAST - STREAM' if item.get('title', '') and item['title'].strip().lower() == name.lower() else None
					if item.get('long_description', '') and len(item['long_description']) > 10:
						description = f"[CR][CR]{item['long_description'][:300].replace(exsin, '').strip()}..." if len(item['long_description']) > 300 else f"[CR][CR]{item['long_description'].replace(exsin, '').strip()}"
					if description == "" and item.get('short_description', '') and len(item['short_description']) > 10:
						description = f"[CR][CR]{item['short_description'][:300].replace(exsin, '').strip()}..." if len(item['short_description']) > 300 else f"[CR][CR]{item['short_description'].replace(exsin, '').strip()}"
					if description == "" and CHAN['name'].lower() == 'wetterpanorama on' and CHAN.get('desc', '') and len(CHAN['desc']) > 10: description = f"[CR][CR]{CHAN['desc'].replace(exsin, '').strip()}"
					episode = 'LIVE - STREAM' if CHAN['name'].lower() in ['servustv live', 'wetterpanorama on'] and epis_check in [None, 'FAST - STREAM'] and not name.startswith(('Terra Mater', 'Wetterpanorama')) else 'FAST - STREAM' if epis_check is None else epis_check
					if CHAN['name'].lower() in ['motorvision', 'motorvision classic', 'scooore', 'servustv live', 'terra mater wild']: # Motorvision, Scooore, ServusTV and Terra Mater : Title and Episode are mixed up
						name, episode = episode if episode != 'FAST - STREAM' else name, name if episode != 'FAST - STREAM' else episode
					if startTIMES and episode:
						CONNECTS.append([CHAN['name'], CHAN['code'], CHAN['video'], startTIMES, name, episode, description])
			if len(CONNECTS) > 5:
				stories = '[CR][CR]'.join([translation(30643).format(each[3], each[4], each[5], each[6]) for each in CONNECTS if each[1] == CHAN['code']])
				photo = f"{artpic}{CHAN['name'].replace(' ', '_').lower()}.png" if xbmcvfs.exists(f"{artpic}{CHAN['name'].replace(' ', '_').lower()}.png") else f"{artpic}channels.png"
				FETCH_UNO = create_entries({'Title': f"[B]{CHAN['name']}[/B]", 'Plot': stories, 'Image': photo})
				addDir({'mode': 'playVideo', 'url': CHAN['video'], 'action': f"LIVE_PLAY@@{CHAN['name']}@@{photo}@@Start: {stories.split('Start: ')[1].split('Start: ')[0]}@@"}, FETCH_UNO, False)
	if FOUND == 0:
		return dialog.notification(translation(30525), translation(30527).format('TV - Kanäle'), icon, 10000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE, succeeded=True, cacheToDisc=False)

def playVideo(UUID, RIDERS): # https://dms.redbull.tv/v5/destination/stv/AAVZ5A09DFS3E6DBDSZE/personal_computer/http/at/de_AT/playlist.m3u8
	debug_MS("(navigator.playVideo) ------------------------------------------------ START = playVideo -----------------------------------------------")
	(FINAL_URL, TEST_URL), (ACCESS, CANTON) = (False for _ in range(2)), Transmission().check_FreeToken()
	if ACCESS:
		if RIDERS.startswith(('LIVE_PLAY', 'EVENT_PLAY')):
			SECTION = RIDERS.split('@@')
			if RIDERS.startswith('LIVE_PLAY'):
				TITLE = translation(30644).format(re.sub(r'(\[/?B\]|ServusTV )', '', SECTION[1]), CANTON.upper())
				THUMB, ASSET, PLOT = SECTION[2], 'CHANNEL', SECTION[3] if len(SECTION) > 4 else ' '
				FINAL_URL = f"{SERTV_HLS}stv-linear/{ACCESS}/playlist.m3u8?namespace=stv" if SECTION[1].lower() == 'servustv live' else UUID
			elif RIDERS.startswith('EVENT_PLAY'):
				TITLE, THUMB, ASSET, PLOT = re.sub(r'\[/?B\]', '', SECTION[1]), SECTION[2], 'EVENT', SECTION[3]
				FINAL_URL = f"{SERTV_HLS}{UUID}/{ACCESS}/playlist.m3u8?namespace=stv"
		else: ASSET, FINAL_URL = 'HLS', f"{SERTV_HLS}{UUID}/{ACCESS}/playlist.m3u8?namespace=stv"
		VERIFY = Transmission().retrieveContent(FINAL_URL, queries='TRACK', raising=False, timeout=15)
		if VERIFY and VERIFY.status_code in [200, 201, 202, 300, 301, 302]: TEST_URL = True
	if FINAL_URL and TEST_URL:
		if RIDERS.startswith(('LIVE_PLAY', 'EVENT_PLAY')):
			LPM = xbmcgui.ListItem(TITLE, path=FINAL_URL, offscreen=True)
			if KODI_ov20:
				LPM.getVideoInfoTag().setTitle(TITLE), LPM.getVideoInfoTag().setPlot(PLOT), LPM.getVideoInfoTag().setStudios(['ServusTV'])
			else: LPM.setInfo('Video', {'Title' : TITLE, 'Plot' : PLOT, 'Studio' : 'ServusTV'})
			LPM.setArt({'icon': icon, 'thumb': THUMB, 'poster': THUMB, 'fanart': defaultFanart})
		else:
			LPM = xbmcgui.ListItem(path=FINAL_URL, offscreen=True)
		if plugin_operate('inputstream.adaptive'):
			IA_NAME = 'inputstream.adaptive'
			IA_VERSION = re.sub(r'(~[a-z]+(?:.[0-9]+)?|\+[a-z]+(?:.[0-9]+)?$|[.^]+)', '', xbmcaddon.Addon(IA_NAME).getAddonInfo('version'))[:4]
			LPM.setMimeType('application/vnd.apple.mpegurl'), LPM.setProperty('inputstream', IA_NAME)
			if KODI_un21:
				LPM.setProperty(f"{IA_NAME}.manifest_type", 'hls') # DEPRECATED ON Kodi v21, because the manifest type is now auto-detected.
				LPM.setProperty(f"{IA_NAME}.manifest_update_parameter", 'full') # THE "full" BEHAVIOUR PARAM HAS BEEN REMOVED ON Kodi v21 because now enabled by default.
			if KODI_ov20:
				LPM.setProperty(f"{IA_NAME}.manifest_headers", f"User-Agent={defaultAgent}") # On KODI v20 and above
			else: LPM.setProperty(f"{IA_NAME}.stream_headers", f"User-Agent={defaultAgent}") # On KODI v19 and below
			if int(IA_VERSION) >= 2150:
				LPM.setProperty(f"{IA_NAME}.drm_legacy", 'org.w3.clearkey')
			if enableSHIFT and RIDERS.startswith(('LIVE_PLAY', 'EVENT_PLAY')):
				LPM.setProperty(f"{IA_NAME}.play_timeshift_buffer", 'true') # If possible allow to start playing a LIVE stream from the beginning of the buffer instead of its end.
		if RIDERS.startswith(('LIVE_PLAY', 'EVENT_PLAY')):
			xbmc.Player().play(item=FINAL_URL, listitem=LPM)
		else: xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, LPM)
		log(f"(navigator.playVideo) {ASSET}_stream : {FINAL_URL}")
	elif FINAL_URL and not TEST_URL:
		failing(f"(navigator.playVideo[1]) ##### Abspielen des Streams NICHT möglich #####\n ##### ERROR_CODE : {VERIFY.status_code} || FINAL_URL : {FINAL_URL} #####\n ########## Die Wiedergabe wurde geblockt !!! ##########")
		return dialog.notification(translation(30521).format('PLAY'), translation(30523).format(f"[B]Code: {VERIFY.status_code}|Text: Dieses Video ist leider nicht verfügbar[/B]"), icon, 17000)
	else:
		failing("(navigator.playVideo[1]) ##### Abspielen des Streams NICHT möglich #####\n ########## Der erforderliche Token wurde leider NICHT gefunden !!! ##########")
		return dialog.notification(translation(30521).format('TOKEN'), translation(30529), icon, 15000)

def listFavorites():
	debug_MS("(navigator.listFavorites) ------------------------------------------------ START = listFavorites -----------------------------------------------")
	if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
		for item in sorted(preserve(FAVORIT_FILE), key=lambda vsx: cleanUmlaut(vsx.get('Cid', 'zorro')).lower()):
			serie, name, link, ACTION = item.get('Cid'), item.get('Title'), item.get('Link'), 'listArchives' if 'landing-page' in item.get('Link') else 'listCategories'
			FETCH_UNO = CONEX_UNO = {'Cid': serie, 'Link': link, 'Title': serie, 'Plot': item.get('Plot'), 'Genre': item.get('Genre'), \
				'Image': item.get('Image'), 'Poster': item.get('Poster'), 'Banner': item.get('Banner'), 'Fanback': item.get('Fanback')}
			debug_MS(f"(navigator.listFavorites[1]) ### NAME : {serie} || SLUG : {link} || THUMB : {item.get('Image')} ###")
			addDir({'mode': ACTION, 'slug': link, 'name': name}, create_entries(FETCH_UNO), True, CONEX_UNO, 'removing')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def favorit_construct(**kwargs):
	TOPS = []
	if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
		TOPS = preserve(FAVORIT_FILE)
	if kwargs['action'] == 'ADD':
		del kwargs['mode']; del kwargs['action']
		TOPS.append({key: value for key, value in kwargs.items() if value not in ['', 'None', None]})
		preserve(FAVORIT_FILE, 'JSON', TOPS)
		xbmc.sleep(500)
		dialog.notification(translation(30532), translation(30533).format(kwargs['Cid']), icon, 10000)
	elif kwargs['action'] == 'DEL':
		TOPS = [xs for xs in TOPS if xs.get('Link') != kwargs.get('Link')]
		preserve(FAVORIT_FILE, 'JSON', TOPS)
		xbmc.executebuiltin('Container.Refresh')
		xbmc.sleep(1000)
		dialog.notification(translation(30532), translation(30534).format(kwargs['Cid']), icon, 10000)

def addDir(params, listitem, folder=True, context={}, handling='default', higher=False):
	uws, entries = build_mass(params), []
	listitem.setPath(uws)
	if enableBACK and higher is True:
		entries.append([translation(30650), f"RunPlugin({build_mass({'mode': 'callingMain'})})"])
	if handling == 'adding' and context:
		entries.append([translation(30651), f"RunPlugin({build_mass({**context, **{'mode': 'favorit_construct', 'action': 'ADD'}})})"])
	if handling == 'removing' and context:
		entries.append([translation(30652), f"RunPlugin({build_mass({**context, **{'mode': 'favorit_construct', 'action': 'DEL'}})})"])
	if len(entries) > 0: listitem.addContextMenuItems(entries)
	return xbmcplugin.addDirectoryItem(ADDON_HANDLE, uws, listitem, folder)
