﻿# -*- coding: utf-8 -*-

import sys
import os
import re
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import json
import xbmcvfs
import shutil
import time
from datetime import datetime, timedelta
from calendar import timegm as TGM
import requests
import ssl
from urllib.parse import parse_qsl, urlencode, quote, quote_plus, unquote_plus
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


HOST_AND_PATH				= sys.argv[0]
ADDON_HANDLE				= int(sys.argv[1])
dialog									= xbmcgui.Dialog()
addon									= xbmcaddon.Addon()
addon_id							= addon.getAddonInfo('id')
addon_name						= addon.getAddonInfo('name')
addon_version					= addon.getAddonInfo('version')
addonPath							= xbmcvfs.translatePath(addon.getAddonInfo('path')).encode('utf-8').decode('utf-8')
dataPath								= xbmcvfs.translatePath(addon.getAddonInfo('profile')).encode('utf-8').decode('utf-8')
COUNTRY_SITE					= int(addon.getSetting('home_country'))
MARKET_CODE					= 'de' if COUNTRY_SITE == 0 else 'at' if COUNTRY_SITE == 1 else 'ch'
tempSERV							= xbmcvfs.translatePath(os.path.join(dataPath, 'tempSERV', '')).encode('utf-8').decode('utf-8')
FREE_SECRET						= xbmcvfs.translatePath(os.path.join(tempSERV, f'clients_data_{MARKET_CODE.upper()}'))
SEARCH_FILE						= xbmcvfs.translatePath(os.path.join(dataPath, 'search_string'))
FAVORIT_FILE						= xbmcvfs.translatePath(os.path.join(dataPath, f'favorites_SERVUS_{MARKET_CODE.upper()}.json'))
defaultFanart						= os.path.join(addonPath, 'resources', 'media', 'fanart.jpg')
icon										= os.path.join(addonPath, 'resources', 'media', 'icon.png')
artpic									= os.path.join(addonPath, 'resources', 'media', '').encode('utf-8').decode('utf-8')
tokenDelay							= {0: 1, 1: 3, 2: 6, 3: 12, 4: 18, 5: 24}[int(addon.getSetting('token_rhythm'))]
#   Zeitrahmen(servustv) = 0: auto|1: 3hrs.|2: 6hrs.|3: 12hrs.|4: 18hrs.|5: 24hrs.
enableSHIFT						= addon.getSetting('allow_timeshift') == 'true'
verify_connection				= (True if addon.getSetting('verify_ssl') == 'true' else False)
enableBACK						= addon.getSetting('show_homebutton') == 'true'
enableADJUSTMENT			= addon.getSetting('show_settings') == 'true'
textSelection						= int(addon.getSetting('field_spread'))
DEB_LEVEL							= (xbmc.LOGINFO if addon.getSetting('enable_debug') == 'true' else xbmc.LOGDEBUG)
SERTV_staticCODE				= addon.getSetting('servus_staticCODE')
KODI_ov20							= int(xbmc.getInfoLabel('System.BuildVersion')[0:2]) >= 20
KODI_un21							= int(xbmc.getInfoLabel('System.BuildVersion')[0:2]) <= 20
BASE_URL							= 'https://www.servustv.com/'
SERTV_HLS							= 'https://dms.redbull.tv/v5/'
SERTV_LP1							= 'https://www.servustv.com/api/v1/media-asset/landing-page-archive/?category={}&currentPage=1&geo={}&newCurrentFilter={}'
SERTV_AV3							= 'https://tv-api.redbull.com/v3/'
SERTV_AP5							= 'https://tv-api.redbull.com/{}/v5/stv/de_{}/{}/{}'
SERTV_ART							= 'https://resources.redbull.tv/'
NEXT_SERTV						= 'https://www.servustv.com/_next/data/' # vTZxe0zrIQYgvkvSJgbfl # CODE of the Webpage
defaultAgent						= 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:141.0) Gecko/20100101 Firefox/141.0'

xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')

def py3_dec(d, nom='utf-8', ign='ignore'):
	if isinstance(d, bytes):
		d = d.decode(nom, ign)
	return d

def translation(id):
	return addon.getLocalizedString(id)

def failing(content):
	log(content, xbmc.LOGERROR)

def debug_MS(content):
	log(content, DEB_LEVEL)

def log(msg, level=xbmc.LOGINFO):
	return xbmc.log(f"[{addon_id} v.{addon_version}]{str(msg)}", level)

def build_mass(body):
	return f"{HOST_AND_PATH}?{urlencode(body)}"

def plugin_operate(MARKING):
	check_uno = xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.GetAddonDetails","params":{{"addonid":"{MARKING}","properties":["enabled"]}}}}')
	answer_uno, answer_due = json.loads(check_uno), json.loads(f'{{"error": "{MARKING} NOT FOUND"}}')
	if not "error" in answer_uno.keys() and answer_uno.get('result', '') and answer_uno['result'].get('addon', {}).get('enabled', False) is False:
		try:
			xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.SetAddonEnabled","params":{{"addonid":"{MARKING}","enabled":true}}}}')
			failing(f"(common.plugin_operate) ERROR - ACTIVATED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT aktiviert !!! #####\n##### Es wird jetzt versucht die Aktivierung durchzuführen !!! #####")
		except: pass
		del answer_due
		check_due = xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.GetAddonDetails","params":{{"addonid":"{MARKING}","properties":["enabled"]}}}}')
		answer_due = json.loads(check_due)
	if (answer_uno.get('result', '') and answer_uno['result'].get('addon', {}).get('enabled', False) is True) or (answer_due.get('result', '') and answer_due['result'].get('addon', {}).get('enabled', False) is True):
		return True
	if answer_due.get('result', '') and answer_due['result'].get('addon', {}).get('enabled', False) is False:
		dialog.ok(addon_id, translation(30501).format(MARKING))
		failing(f"(common.plugin_operate) ERROR - ACTIVATED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT aktiviert !!! #####\n##### Eine automatische Aktivierung ist leider NICHT möglich !!! #####")
	if "error" in answer_uno.keys() or "error" in answer_due.keys():
		dialog.ok(addon_id, translation(30502).format(MARKING))
		failing(f"(common.plugin_operate) ERROR - INSTALLED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT installiert !!! #####")
	return False

def getSorting():
	return [xbmcplugin.SORT_METHOD_UNSORTED, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE, xbmcplugin.SORT_METHOD_DURATION, xbmcplugin.SORT_METHOD_EPISODE, xbmcplugin.SORT_METHOD_DATE]

def get_CentralTime(indicator, event='EPOCHTIME'):
	CONVERTED = indicator if event == 'EPOCHTIME' else datetime(*(time.strptime(indicator[:19], '%Y-%m-%dT%H:%M:%S')[0:6]))
	try: # 1702235640 or 2024-02-23T04:17:00.000Z
		LOCAL_DATE = datetime.fromtimestamp(TGM(CONVERTED.timetuple()))
		assert CONVERTED.resolution >= timedelta(microseconds=1)
		LOCAL_DATE = LOCAL_DATE.replace(microsecond=CONVERTED.microsecond)
	except (ValueError, OverflowError): # ERROR on Android 32bit Systems = cannot convert unix timestamp over year 2038
		LOCAL_DATE = datetime.fromtimestamp(0) + timedelta(seconds=TGM(CONVERTED.timetuple()))
		LOCAL_DATE = LOCAL_DATE - timedelta(hours=datetime.timetuple(LOCAL_DATE).tm_isdst)
	return LOCAL_DATE

def get_Picture(elem_code, elem_type, elem_width='1200', quality='70'):
	return f"{SERTV_ART}{elem_code}/rbtv_display_art_{elem_type}/im:i:w_{elem_width},g_faces,c_fill,dpr_1.0,q_{quality},f_webp?namespace=stv&refresh=true"

def preserve(store, action='JSON', data=None):
	if data is not None:
		with open(store, 'w') as topics:
			json.dump(data, topics, indent=2, sort_keys=True) if action == 'JSON' else topics.write(data)
	else:
		with open(store, 'r') as topics:
			arrive = json.load(topics) if action == 'JSON' else topics.read()
		return arrive

def cleanUmlaut(wrong):
	if wrong is not None:
		for wg in (('ä', 'ae'), ('Ä', 'Ae'), ('ü', 'ue'), ('Ü', 'Ue'), ('ö', 'oe'), ('Ö', 'Oe'), ('ß', 'ss')):
			wrong = wrong.replace(*wg)
		wrong = wrong.strip()
	return wrong

def create_entries(metadata, SIGNS=None):
	listitem = xbmcgui.ListItem(metadata['Title'])
	vinfo = listitem.getVideoInfoTag() if KODI_ov20 else {}
	if KODI_ov20: vinfo.setTitle(metadata['Title'])
	else: vinfo['Title'] = metadata['Title']
	if metadata.get('TvShowTitle', ''):
		if KODI_ov20: vinfo.setTvShowTitle(metadata['TvShowTitle'])
		else: vinfo['Tvshowtitle'] = metadata['TvShowTitle']
	if metadata.get('Tagline', ''):
		if KODI_ov20: vinfo.setTagLine(metadata['Tagline'])
		else: vinfo['Tagline'] = metadata['Tagline']
	description = metadata['Plot'] if metadata.get('Plot') not in ['', 'None', None] else ' '
	if KODI_ov20: vinfo.setPlot(description)
	else: vinfo['Plot'] = description
	if str(metadata.get('Duration')).isdecimal():
		if KODI_ov20: vinfo.setDuration(int(metadata['Duration']))
		else: vinfo['Duration'] = metadata['Duration']
	if str(metadata.get('Season')).isdecimal():
		if KODI_ov20: vinfo.setSeason(int(metadata['Season']))
		else: vinfo['Season'] = metadata['Season']
	if str(metadata.get('Episode')).isdecimal():
		if KODI_ov20: vinfo.setEpisode(int(metadata['Episode']))
		else: vinfo['Episode'] = metadata['Episode']
	if metadata.get('Date', ''):
		if KODI_ov20: listitem.setDateTime(metadata['Date'])
		else: vinfo['Date'] = metadata['Date']
	if metadata.get('Aired', ''):
		if KODI_ov20: vinfo.setFirstAired(metadata['Aired'])
		else: vinfo['Aired'] = metadata['Aired']
	if metadata.get('Genre', ''):
		if KODI_ov20: vinfo.setGenres([metadata['Genre']])
		else: vinfo['Genre'] = metadata['Genre']
	if metadata.get('Mpaa', ''):
		if KODI_ov20: vinfo.setMpaa(str(metadata['Mpaa']))
		else: vinfo['Mpaa'] = str(metadata['Mpaa'])
	if KODI_ov20: vinfo.setStudios(['ServusTV'])
	else: vinfo['Studio'] = 'ServusTV'
	if metadata.get('Mediatype', ''):
		if KODI_ov20: vinfo.setMediaType(metadata['Mediatype'])
		else: vinfo['Mediatype'] = metadata['Mediatype']
	picture, portrait, banner = metadata.get('Image', icon), (metadata.get('Poster', '') or metadata.get('Image', icon)), metadata.get('Banner', None)
	listitem.setArt({'icon': icon, 'thumb': picture, 'poster': portrait, 'banner': banner, 'fanart': defaultFanart})
	if metadata.get('Fanback', '') and not artpic in metadata['Fanback']:
		listitem.setArt({'fanart': metadata['Fanback']})
	if metadata.get('Reference') == 'Single':
		listitem.setProperty('IsPlayable', 'true')
	if not KODI_ov20: listitem.setInfo('Video', vinfo)
	return listitem
