﻿# -*- coding: utf-8 -*-

from .common import *


def getSignatures():
	NEXT_START = addon.getSetting('next_process')
	STORE_START = datetime(*(time.strptime(NEXT_START[:19], '%Y-%m-%d %H:%M:%S')[0:6])) # 2025-04-12 14:10:00
	if not xbmcvfs.exists(os.path.join(dataPath, 'settings.xml')) or datetime.now() > STORE_START or addon.getSetting('device_uid') == 'unknown' or addon.getSetting('publisher_provided_id') == 'unknown':
		NEXT_TASK = datetime.now() + timedelta(hours=2)
		addon.setSetting('next_process', str(NEXT_TASK)[:19])
		addon.setSetting('device_uid', str(uuid.uuid4()))
		addon.setSetting('publisher_provided_id', str(uuid.uuid4()))

def mainMenu():
	debug_MS("(navigator.mainMenu) ------------------------------------------------ START = mainMenu -----------------------------------------------")
	for TITLE, PATH in [(30601, {'mode': 'listFavorites'}), (30602, {'mode': 'listRecords', 'slug': 'free'}), (30603, {'mode': 'listGenres'}),
		(30604, {'mode': 'listBroadcasts', 'slug': 'free-all-movies', 'name': 'Alle kostenlose Filme'}), (30605, {'mode': 'SearchRKTV'}),
		(30606, {'mode': 'listCategoriesTV'})]:
		addDir(PATH, create_entries({'Title': translation(TITLE), 'Image': f"{artpic}favourites.png" if TITLE == 30601 else f"{artpic}basesearch.png" if TITLE == 30605 else icon}))
	CANTON, IMAGE = country_check()
	TEXTBOX, PHOTO = translation(30610).format(CANTON, MARKET_CODE.upper()), f"{artpic}settings.png" if IMAGE == 'unk' else IMAGE
	LAYOUT = translation(30611)+TEXTBOX if textSelection == 0 else TEXTBOX+translation(30611) if textSelection == 1 else TEXTBOX if textSelection == 2 else translation(30611)
	if enableADJUSTMENT:
		addDir({'mode': 'aConfigs'}, create_entries({'Title': LAYOUT, 'Image': PHOTO}), folder=False)
		if plugin_operate('inputstream.adaptive'):
			addDir({'mode': 'iConfigs'}, create_entries({'Title': translation(30612), 'Image': f"{artpic}settings.png"}), folder=False)
	else:
		addDir({'mode': 'blankFUNC'}, create_entries({'Title': TEXTBOX, 'Image': PHOTO}), folder=False)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listGenres():
	debug_MS("(navigator.listGenres) ------------------------------------------------ START = listGenres -----------------------------------------------")
	DATA_ONE = getContent(f"{API_GIZMO}/banner_lists/896", params=paras_USER, headers=head_WEB)
	for item in sorted(DATA_ONE['data'].get('banners', []), key=lambda gnx: cleanUmlaut(gnx.get('display_title', 'zorro')).lower()):
		if item.get('target', '') and (item['target'].get('type', 'gardens') != 'gardens' or item['target'].get('id', 'passion') in ['awards-season', 'pride']):
			continue
		TITLE = item['display_title']
		GID = item['target'].get('id', 'passion')
		THUMB = (item.get('image', '') or item.get('image_webp', ''))
		FANART = (item.get('background_image', '') or item.get('background_image_webp', '') or defaultFanart)
		debug_MS(f"(navigator.listGenres[1]) ##### TITLE : {TITLE} || SLUG : {GID} || THUMB : {THUMB} #####")
		addDir({'mode': 'listRecords', 'slug': GID, 'pic': THUMB, 'fan': FANART}, create_entries({'Title': TITLE, 'Image': THUMB, 'Fanback': FANART}))
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listRecords(SLUG, PIC, FAN):
	debug_MS("(navigator.listRecords) ------------------------------------------------ START = listRecords -----------------------------------------------")
	debug_MS(f"(navigator.listRecords) ### SLUG = {SLUG} ### THUMB = {PIC} ### FANART = {FAN} ###")
	categories, (FOUND, COUNT), (CONNECT, COLLAGE) = {}, (0 for _ in range(2)), ([] for _ in range(2))
	if preserve(RECORD_FILE, 24) is None:
		DATA_ONE = getContent(f"{API_GIZMO}/skeleton/gardens/free", params=paras_USER, headers=head_WEB)
		for records in DATA_ONE['data'].get('lists', []):
			if records.get('content_type', '') in ['Movie', 'TvShow'] and records.get('id', 'unknown').startswith(('free', 'rakuten')):
				FOUND += 1
				CONNECT.append([int(FOUND), f"{API_GIZMO}/lists/{records['id']}"])
		if not 'free-asian-movies' in CONNECT: CONNECT.append([int(FOUND)+1, f"{API_GIZMO}/lists/free-asian-movies"])
		if CONNECT:
			DETAILS = json.loads(getMultiData(CONNECT))
			for multi in DETAILS:
				if multi is not None and multi.get('data', '') and len(multi['data']) > 0:
					NUMBER, LINK = multi.get('Position', 0), multi.get('Demand', '')
					NAME = re.sub(r'(KOSTENLOS \| |Kostenslose |Kostenlose )', '', multi['data'].get('name', 'NOT FOUND'))
					categories[LINK.split('lists/')[1]] = NAME
					debug_MS(f"(navigator.listRecords[1]) ##### COUNTER-1 : {NUMBER} || TITLE-1 : {NAME} || SLUG-1 : {LINK.split('lists/')[1]} #####")
			preserve(RECORD_FILE, 24, categories)
	if preserve(RECORD_FILE, 24) is not None:
		debug_MS("---------------------------------------------")
		medias, DATA_TWO = preserve(RECORD_FILE, 24), getContent(f"{API_GIZMO}/skeleton/gardens/{SLUG}", params=paras_USER, headers=head_WEB)
		for item in DATA_TWO['data'].get('lists', []):
			if item.get('content_type', '') in ['Movie', 'TvShow'] and item.get('id', 'unknown').startswith(('free', 'rakuten')):
				RID = item['id']
				LABEL = medias[RID] if RID in medias else None
				if LABEL is None: continue
				COUNT += 1
				debug_MS(f"(navigator.listRecords[2]) ##### COUNTER-2 : {COUNT} || TITLE-2 : {LABEL} || SLUG-2 : {RID} #####")
				COLLAGE.append([int(COUNT), LABEL, RID])
	if COLLAGE and COUNT == 1:
		debug_MS("(navigator.listRecords[3]) ----- Only one Record FOUND - goto = listBroadcasts -----")
		for COUNT, LABEL, RID in COLLAGE:
			return listBroadcasts(RID, 1, LABEL)
	elif COLLAGE and COUNT > 1:
		for COUNT, LABEL, RID in sorted(COLLAGE, key=lambda cn: int(cn[0])):
			if SLUG == 'free': FETCH_UNO = create_entries({'Title': LABEL, 'Image': 'DefaultGenre.png'})
			elif SLUG != 'free': FETCH_UNO = create_entries({'Title': LABEL, 'Image': PIC, 'Fanback': FAN})
			addDir({'mode': 'listBroadcasts', 'slug': RID, 'name': LABEL}, FETCH_UNO)
	else:
		failing(f'(navigator.listRecords) NO RECORD-LIST - NO ENTRY FOR: "{SLUG}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(f"{SLUG} [FREE]"), icon, 10000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listBroadcasts(SLUG, PAGE, NAME):
	debug_MS("(navigator.listBroadcasts) ------------------------------------------------ START = listBroadcasts -----------------------------------------------")
	debug_MS(f"(navigator.listBroadcasts) ### SLUG = {SLUG} ### PAGE = {PAGE} ### NAME = {NAME} ###")
	FOUND, DATA_ONE, SUFFIX = 0, {}, ""
	if SLUG.startswith('searching:'):
		paras_WEB.update({'page': str(PAGE), 'per_page': '200', 'query': quote(SLUG.split('@@')[1]), 'search_engine': 'external'})
		DATA_ONE = getContent(f"{API_GIZMO}/{SLUG[10:].split('@@')[0]}", params=paras_WEB, headers=head_WEB)
	else:
		paras_WEB.update({'page': str(PAGE), 'per_page': str(LIMITATION)})
		DATA_ONE = getContent(f"{API_GIZMO}/lists/{SLUG}/contents", params=paras_WEB, headers=head_WEB)
	for item in DATA_ONE.get('data', []):
		if item.get('labels', '') and item['labels'].get('purchase_types', '') and len(item['labels']['purchase_types']) > 0 and item['labels'].get('purchase_types', {})[0].get('kind', 'avod') != 'avod':
			continue
		each, folder, SEASON, FETCH_UNO, context, operation = create_substances(item, 'series'), True, "", {}, {}, 'adding'
		# [slug=0, species=1, name=2, origtitle=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, year=11, production=12]
		# [genre=13, country=14, director=15, cast_small=16, CASTING=17, rating=18, mpaa=19, studio=20, thumb=21, poster=22, clearlogo=23, fanback=24]
		FOUND += 1
		PLOT = each[9]+each[10]+each[5]
		FETCHING = {'Species': each[1], 'Title': each[2], 'Year': each[11], 'Genre': each[13], 'Rating': each[18], \
			'Mpaa': each[19], 'Image': each[21], 'Poster': each[22], 'Logo': each[23], 'Fanback': each[24]}
		if each[1] == 'movies':
			DURATION = each[6]*60 if each[6] is not None else None
			folder, ACTION = False, {'mode': 'playVideo', 'slug': each[0], 'species': each[1]}
			debug_MS(f"(navigator.listBroadcasts[1]) ##### NAME : {each[2]} || SLUG : {each[0]} || GENRE : {each[13]} #####")
			debug_MS(f"(navigator.listBroadcasts[1]) ##### YEAR : {each[11]} || RATING : {each[18]} || THUMB : {each[21]} #####")
			FETCH_UNO = context = {**FETCHING, **{'Slug': each[0], 'Plot': PLOT, 'Duration': DURATION, 'Mediatype': 'movie', 'Reference': 'Single'}}
		elif each[1] == 'tv_shows':
			SEASON = [sea.get('id', '') for sea in item.get('seasons', [])][0]
			DESC = translation(30620).format(PLOT, each[12]) if each[12] is not None else PLOT
			folder, ACTION = True, {'mode': 'listSeasons', 'slug': SEASON, 'name': each[2]}
			debug_MS(f"(navigator.listBroadcasts[2]) ##### NAME : {each[2]} || SLUG : {each[0]} || GENRE : {each[13]} #####")
			debug_MS(f"(navigator.listBroadcasts[2]) ##### YEAR : {each[12]} || RATING : {each[18]} || THUMB : {each[21]} #####")
			FETCH_UNO = context = {**FETCHING, **{'Slug': SEASON, 'TvShowTitle': each[4], 'Plot': DESC}}
		debug_MS("++++++++++++++++++++++++")
		if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
			for article in preserve(FAVORIT_FILE, 0):
				if article.get('Slug') in [each[0], SEASON]: operation = 'skipping'
		addDir(ACTION, create_entries(FETCH_UNO), folder, context, operation)
	ENTIRE = DATA_ONE['meta']['pagination']['total_pages'] if DATA_ONE.get('meta', {}) and DATA_ONE['meta'].get('pagination', {}) and \
		DATA_ONE['meta']['pagination'].get('total_pages', '') and str(DATA_ONE['meta']['pagination']['total_pages']).isdecimal() else None
	if not SLUG.startswith('searching:') and FOUND > 0 and ENTIRE and int(ENTIRE) > int(PAGE):
		debug_MS(f"(navigator.listBroadcasts[3]) PAGES ### NOW SHOW NEXTPAGE ENTRY ... No.{int(PAGE)+1} ... ###")
		FETCH_DUE = create_entries({'Title': translation(30621).format(int(PAGE)+1), 'Image': f"{artpic}nextpage.png"})
		addDir({'mode': 'listBroadcasts', 'slug': SLUG, 'page': int(PAGE)+1, 'name': NAME}, FETCH_DUE)
	elif FOUND == 0:
		failing(f'(navigator.listBroadcasts) ##### NO BROADCAST-LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(f"{NAME} [FREE]"), icon, 10000)
	xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def SearchRKTV(keyword=None, search_Select='movies'):
	debug_MS("(navigator.SearchDFBTV) ------------------------------------------------ START = SearchDFBTV -----------------------------------------------")
	if xbmcvfs.exists(SEARCH_FILE):
		with open(SEARCH_FILE, 'r') as look:
			keyword = look.read()
	if xbmc.getInfoLabel('Container.FolderPath') == HOST_AND_PATH: # !!! this hack is necessary to prevent KODI from opening the input mask all the time !!!
		search_Ways = [xs for xs in ['movies', 'tv_shows']]
		search_Index = dialog.select(translation(30622), [translation(30623), translation(30624)], preselect=0)
		search_Select = search_Ways[search_Index] if search_Index > -1 else search_Ways[0]
		keyword = dialog.input(heading=translation(30625), type=xbmcgui.INPUT_ALPHANUM, autoclose=15000)
		if keyword:
			with open(SEARCH_FILE, 'w') as record:
				record.write(keyword)
	if keyword: return listBroadcasts(f"searching:{search_Select}@@{keyword}", 1, keyword)
	return None

def callingInfos(SLUG):
	DATA = getContent(f"{API_GIZMO}/movies/{SLUG}", params=paras_DASH, headers=head_WEB).get('data', {})
	entries = create_substances(DATA, 'informations')
	# [slug=0, species=1, name=2, origtitle=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, year=11, production=12]
	# [genre=13, country=14, director=15, cast_small=16, CASTING=17, rating=18, mpaa=19, studio=20, thumb=21, poster=22, clearlogo=23, fanback=24]
	plot = translation(30630).format(entries[2]) # Title
	plot += translation(30631).format(entries[3]) if len(entries[3]) > 0 else '[CR]' # Originaltitle
	if entries[12] is not None: plot +=translation(30632).format(entries[12]) # Production
	if entries[6] is not None: plot += translation(30633).format(entries[6]) # Duration
	if entries[13] is not None and len(entries[13]) > 0: plot += translation(30634).format(entries[13]) # Genre
	if entries[14] is not None and len(entries[14]) > 0: plot += translation(30635).format(entries[14]) # Country
	if entries[16] is not None and len(entries[16]) > 0: plot += translation(30636).format(entries[16]) # Cast-Names small
	if entries[15] is not None and len(entries[15]) > 0: plot += translation(30637).format(entries[15]) # Director-Names
	if entries[20] is not None: plot += translation(30638).format(entries[20]) # Studio
	if entries[19] is not None and len(entries[19]) > 0: plot += translation(30639).format(entries[19]) # Mpaa
	if entries[18] is not None and isinstance(entries[18], float): plot += translation(30640).format(entries[18]) # Rating
	if len(entries[5]) > 0: plot += f"[CR]{entries[5]}" # Description
	if len(plot) < 40:
		plot = translation(30641) # Nothing found
	plot += f"[CR][CR]{getLanguages(DATA)}" # Subtitles
	dialog.textviewer(translation(30642), plot)

def listSeasons(SLUG, NAME):
	debug_MS("(navigator.listSeasons) ------------------------------------------------ START = listSeasons -----------------------------------------------")
	debug_MS(f"(navigator.listSeasons) ### SLUG = {SLUG} ### NAME = {NAME} ###")
	FOUND, COLLAGE, DATA_ONE = 0, [], getContent(f"{API_GIZMO}/seasons/{SLUG}", params=paras_DASH, headers=head_WEB)
	elements = [DATA_ONE.get('data', {})] + DATA_ONE['data'].get('other_seasons', []) if DATA_ONE.get('data', {}) and \
		DATA_ONE['data'].get('other_seasons', []) and len(DATA_ONE['data']['other_seasons']) > 0 else [DATA_ONE.get('data', {})]
	for item in elements:
		each = create_substances(item)
		# [slug=0, species=1, name=2, origtitle=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, year=11, production=12]
		# [genre=13, country=14, director=15, cast_small=16, CASTING=17, rating=18, mpaa=19, studio=20, thumb=21, poster=22, clearlogo=23, fanback=24]
		FOUND += 1
		debug_MS(f"(navigator.listSeasons[1]) ### NAME : {each[2]} || SLUG : {each[0]} || THUMB : {each[21]} ###")
		COLLAGE.append([each[0], each])
	if COLLAGE and FOUND == 1:
		log("(navigator.listSeasons[2]) ----- Only one Season FOUND - goto = listEpisodes -----")
		for SEID, SCON in COLLAGE:
			return listEpisodes(SEID, SCON[2])
	elif COLLAGE and FOUND > 1:
		for SEID, SCON in COLLAGE:
			PLOT = SCON[9]+SCON[10]+SCON[5]
			FETCH_UNO = create_entries({'Title': SCON[2], 'TvShowTitle': SCON[4], 'Plot': PLOT, 'Year': SCON[11], 'Genre': SCON[13], \
				'Mpaa': SCON[19], 'Image': SCON[21], 'Poster': SCON[22], 'Logo': SCON[23], 'Fanback': SCON[24]})
			addDir({'mode': 'listEpisodes', 'slug': SEID, 'name': SCON[2]}, FETCH_UNO)
	else:
		failing(f'(navigator.listSeasons) ##### NO SEASON-LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(NAME), icon, 10000)
	xbmcplugin.setContent(ADDON_HANDLE, 'seasons')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listEpisodes(SLUG, NAME):
	debug_MS("(navigator.listEpisodes) -------------------------------------------------- START = listEpisodes --------------------------------------------------")
	debug_MS(f"(navigator.listEpisodes) ### SLUG = {SLUG} ### NAME = {NAME} ###")
	FOUND, DATA_ONE = 0, getContent(f"{API_GIZMO}/seasons/{SLUG}", params=paras_DASH, headers=head_WEB)
	for item in DATA_ONE.get('data', {}).get('episodes', []):
		each = create_substances(item, 'episodes')
		# [slug=0, species=1, name=2, origtitle=3, seriestitle=4, desc=5, duration=6, season=7, episode=8, note_1=9, note_2=10, year=11, production=12]
		# [genre=13, country=14, director=15, cast_small=16, CASTING=17, rating=18, mpaa=19, studio=20, thumb=21, poster=22, clearlogo=23, fanback=24]
		if each[15] is None or len(each[17]) == 0: # Director or CASTING
			additive = create_substances(DATA_ONE.get('data', {}))
			director, cast = additive[15], additive[17]
		else: director, cast = each[15], each[17]
		FOUND += 1
		PLOT, CLEARED = each[9]+each[10]+each[5], re.sub('(\[/?COLOR.*?\])', '', each[2])
		PLOT += f"[CR][CR]{getLanguages(item)}" # Subtitles
		debug_MS(f"(navigator.listEpisodes[2]) ##### NAME : {CLEARED} || SLUG : {each[0]} || GENRE : {each[13]} #####")
		debug_MS(f"(navigator.listEpisodes[2]) ##### DURATION : {each[6]} || FSK : {each[19]} || THUMB : {each[21]} #####")
		debug_MS("++++++++++++++++++++++++")
		FETCH_UNO = create_entries({'Title': each[2], 'TvShowTitle': each[4], 'Plot': PLOT, 'Season': each[7], 'Episode': each[8], \
			'Duration': each[6], 'Year': each[11], 'Genre': each[13], 'Director': director, 'Cast': cast, 'Rating': each[18], 'Mpaa': each[19], \
			'Mediatype': 'episode', 'Image': each[21], 'Logo': each[23], 'Fanback': each[24], 'Reference': 'Single'})
		addDir({'mode': 'playVideo', 'slug': each[0], 'species': each[1], 'seid': SLUG}, FETCH_UNO, folder=False)
	if FOUND == 0:
		failing(f'(navigator.listEpisodes) ##### NO EPISODE-LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(NAME), icon, 10000)
	xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def getLanguages(RDATA):
	riders, (array_lang, array_subs), content = "", ([] for _ in range(2)), RDATA['view_options']['private'].get('streams', [])
	if len(content) == 1:
		audio_titles = content[0].get('audio_languages', {})
		subid_titles = content[0].get('subtitle_languages', {})
	elif len(content) == 2:
		hearing = content[0].get('audio_languages', {})+content[1].get('audio_languages', {})
		audio_titles = [ne for me, ne in enumerate(hearing) if ne not in hearing[:me]] # Filtering double Entries out
		viewing = content[0].get('subtitle_languages', {})+content[1].get('subtitle_languages', {})
		subid_titles = [ev for ew, ev in enumerate(viewing) if ev not in viewing[:ew]] # Filtering double Entries out
	for lang in sorted(audio_titles, key=lambda an: cleanUmlaut(an.get('name', 'zorro')).lower()):
		array_lang.append(lang.get('name', ''))
	for subs in sorted(subid_titles, key=lambda sn: cleanUmlaut(sn.get('name', 'zorro')).lower()):
		array_subs.append(subs.get('name', ''))
	riders += f"{translation(30660)}{', '.join(array_lang)}[CR]"
	riders += f"{translation(30661)}{', '.join(array_subs)}"
	return riders

def create_substances(rsx, others=None):
	CASTING, (note_1, note_2), fanback = [], ("" for _ in range(2)), defaultFanart
	season, episode, genre, country, director, cast_small, mpaa, thumb, poster, clearlogo = (None for _ in range(10))
	slug = rsx.get('id', None)
	species = rsx.get('type', None)
	title = (rsx.get('title', '') or rsx.get('display_name', ''))
	origtitle = rsx.get('original_title', '')
	origserie = rsx.get('tv_show_title', None)
	if origserie is None and rsx.get('tv_show', '') and rsx['tv_show'].get('title', ''):
		origserie = rsx['tv_show']['title']
	if origserie is None and others == 'series' and species == 'tv_shows':
		origserie = title
	seriestitle, note_1 = origserie if origserie else None, translation(30670).format(origserie) if origserie and others != 'series' else ""
	desc = (rsx.get('plot', '') or rsx.get('short_plot', ''))
	duration = int(rsx['duration']) if str(rsx.get('duration')).isdecimal() and int(rsx['duration']) != 0 else None
	if others == 'episodes':
		duration = int(rsx['duration_in_seconds']) if str(rsx.get('duration_in_seconds')).isdecimal() else None
		season = f"{int(rsx['season_number']):02}" if str(rsx.get('season_number')).isdecimal() and int(rsx.get('season_number')) != 0 else None
		episode = f"{int(rsx['number']):02}" if str(rsx.get('number')).isdecimal() and int(rsx.get('number')) != 0 else None
		if season and episode:
			name = translation(30671).format(season, episode, title)
			note_2 = translation(30672).format(season, episode)
		elif season and episode is None:
			name = translation(30673).format(season, title)
			note_2 = translation(30674).format(season)
		else: name= title
	else: name= title
	if (note_1 != "" or note_2 != "") and desc != "" and others != 'informations': desc = f"[CR]{desc}"
	production = rsx.get('years', None)
	year = rsx['year'] if str(rsx.get('year')).isdecimal() else None
	if rsx.get('genres', '') and isinstance(rsx['genres'], list):
		genre = ' / '.join(sorted([gen.get('name', '') for gen in rsx.get('genres', [])]))
	if rsx.get('countries', '') and isinstance(rsx['countries'], list):
		country = ', '.join(sorted([cou.get('name', '') for cou in rsx.get('countries', [])]))
	if rsx.get('directors', '') and isinstance(rsx['directors'], list):
		director = ', '.join(sorted([rec.get('name', '') for rec in rsx.get('directors', [])]))
	if rsx.get('actors', '') and isinstance(rsx['actors'], list):
		cast_small = ', '.join(sorted([act.get('name', '') for act in rsx.get('actors', [])]))
		for index, person in enumerate(rsx.get('actors', []), 1):
			actor = {'name': person.get('name', None), 'role': '', 'order': index, 'thumb': person.get('photo', '')}
			if actor['name'] not in ['' , None]:
				if KODI_ov20: CASTING.append(xbmc.Actor(actor['name'], actor['role'], actor['order'], actor['thumb']))
				else: CASTING.append(actor)
	rating = rsx['highlighted_score']['score'] if rsx.get('highlighted_score', '') and rsx['highlighted_score'].get('score', '') else None
	if rating is None and others == 'informations' and rsx.get('scores', '') and 'score' in str(rsx['scores']) and len(rsx['scores']) > 0:
		rating = rsx['scores'][0]['score']
	if rsx.get('classification', '') and rsx['classification'].get('name', ''):
		mpaa = str(rsx['classification']['name'])
	studio = rsx['provider_name'].split('-')[1] if rsx.get('provider_name', None) is not None else None
	if rsx.get('images', '') and len(rsx['images']) > 0:
		thumb = (rsx['images'].get('snapshot', '') or rsx['images'].get('snapshot_webp', ''))
		poster = (rsx['images'].get('artwork', '') or rsx['images'].get('artwork_webp', ''))
		clearlogo = (rsx['images'].get('title_treatment', '') or rsx['images'].get('title_treatment_webp', ''))
		fanback = (rsx['images'].get('snapshot', '') or rsx['images'].get('snapshot_webp', '') or defaultFanart)
	return [slug, species, name, origtitle, seriestitle, desc, duration, season, episode, note_1, note_2, year, production, genre, country, director, cast_small, CASTING, rating, mpaa, studio, thumb, poster, clearlogo, fanback]

def playVideo(SLUG, SPECIES, SEID=None):
	debug_MS("(navigator.playVideo) -------------------------------------------------- START = playVideo --------------------------------------------------")
	debug_MS(f"(navigator.playVideo) ### SLUG = {SLUG} ### SPECIES = {SPECIES} ### SEID = {SEID} ###")
	(DATA_ONE, audio_Select, subid_Result, subid_Marker, subid_Select, DRM_SPECIES), (FINAL_URL, force_Subs) = (None for _ in range(6)), (False for _ in range(2))
	unpack, excluded, (private, audio_Names, audio_Codes, subid_Names, subid_Streams, subid_Collect) = True, 0, ([] for _ in range(6))
	TARGET = f"{API_GIZMO}/movies/{SLUG}" if SPECIES=='movies' else f"{API_GIZMO}/seasons/{SEID}"
	DATA_ONE = getContent(TARGET, params=paras_DASH, headers=head_WEB)
	debug_MS(f"(navigator.playVideo[1]) XXXXX DATA_ONE-01 : {DATA_ONE} XXXXX")
	debug_MS("++++++++++++++++++++++++")
	if SPECIES == 'movies':
		private = DATA_ONE['data']['view_options']['private'].get('streams', [])
	elif SPECIES == 'episodes':
		epis_slug = [ep for ep in DATA_ONE['data'].get('episodes', []) if ep.get('id') == SLUG][0]
		private = epis_slug['view_options']['private'].get('streams', [])
	if len(private) == 1:
		audio_langs = private[0].get('audio_languages', {})
		subid_langs = private[0].get('subtitle_languages', {})
	elif len(private) == 2:
		hearing = private[0].get('audio_languages', {})+private[1].get('audio_languages', {})
		audio_langs = [hx for mx, hx in enumerate(hearing) if hx not in hearing[:mx]] # Filtering double Entries out
		viewing = private[0].get('subtitle_languages', {})+private[1].get('subtitle_languages', {})
		subid_langs = [vx for nx, vx in enumerate(viewing) if vx not in viewing[:nx]] # Filtering double Entries out
	for al, languages in enumerate(sorted(audio_langs, key=lambda an: cleanUmlaut(an.get('name', 'Zorro'))), 1):
		audio_Names.append(f"[B]{languages.get('name')}[/B]")
		audio_Codes.append(languages.get('id', 'MIS'))
	CLEARED = [re.sub('(\[/?B\])', '', cd) for cd in audio_Names]
	debug_MS(f"(navigator.playVideo[2]) ##### AUD_NAMES = {CLEARED} || AUD_CODES = {audio_Codes} #####")
	if audio_Codes and len(audio_Codes) > 0 and ((prefAUDIO == 0) or (prefAUDIO == 1 and not 'DEU' in audio_Codes)):
		audio_Result = 'DEU' if 'DEU' in audio_Codes else audio_Codes[0]
		if audio_Names:
			audio_Index = dialog.select(translation(30690), audio_Names, preselect=0)
			audio_Select = audio_Codes[audio_Index] if audio_Index > -1 else None
		if audio_Select: audio_Result = audio_Select
	else: audio_Result = 'DEU'
	specs = {"audio_language":audio_Result,"audio_quality":"2.0","classification_id":CLASSIFICATION,"content_id":SLUG,"content_type":SPECIES,"device_make":"chrome","device_model":"GENERIC",\
		"device_serial":"not implemented","device_stream_video_quality":"HD","device_uid":addon.getSetting('device_uid'),"device_year":1970,"hdr_type": "NONE","player":"web:DASH-CENC","video_type":"stream",\
		"publisher_provided_id":addon.getSetting('publisher_provided_id'),"strict_video_quality":False,"subtitle_formats":["vtt"],"subtitle_language":"MIS","support_closed_captions":True,"support_thumbnails":True}
	DATA_TWO = getContent(f"{API_GIZMO}/avod/streamings", 'POST', params=paras_DASH, headers=head_WEB, json=specs)
	debug_MS(f"(navigator.playVideo[3]) XXXXX DATA_TWO-02 : {DATA_TWO} XXXXX")
	debug_MS("++++++++++++++++++++++++")
	DATA_TWO = DATA_TWO['data'].get('stream_infos', [])[0]
	FINAL_URL = DATA_TWO['url']
	DRM_GUARD = DATA_TWO.get('license_url', None)
	subid_links = [su for su in DATA_TWO.get('all_subtitles', []) if su.get('format', '') == 'vtt' and su.get('subtitle_type', '') == SUB_TYPE]
	for each_one in subid_langs:
		for each_two in subid_links:
			if each_one.get('id', 'MIS') == each_two.get('language', 'MIS'):
				each_one.update(each_two) # Update subid_langs Entries with subid_links Entries
	if audio_Result == 'DEU' and COUNTRY_CODE == 'MIS': unpack = False
	if unpack is True:
		for sl, subtitles in enumerate(sorted(subid_langs, key=lambda sn: cleanUmlaut(sn.get('name', 'Zorro'))), 1):
			subid_Names.append(f"[B]{subtitles.get('name')}[/B]")
			subid_Streams.append(subtitles.get('url', None))
			subid_Collect.append({'filter': subtitles.get('id', 'MIS'), 'marks': subtitles.get('name'), 'slink': subtitles.get('url', None)})
	if subid_Streams and len(subid_Streams) > 0 and enableVODSUBS:
		for elem in subid_Collect:
			if elem['slink'] is None: excluded += 1
			if elem['filter'] == COUNTRY_CODE and elem['slink'] is not None:
				subid_Result, subid_Marker = elem['slink'], elem.get('marks')
		if len(subid_Streams) == excluded and excluded > 1:
			notices = translation(30527) if SUB_TYPE == 'full' else translation(30528)
			dialog.notification(translation(30525), notices, icon, 10000)
		elif len(subid_Streams) != excluded and (subid_Result is None or COUNTRY_CODE == 'AIO'):
			subid_Index = dialog.select(translation(30691), subid_Names, preselect=0)
			subid_Select = subid_Streams[subid_Index] if subid_Index > -1 else None
		if subid_Select: subid_Result = subid_Select
		if subid_Result is not None: force_Subs = True
	debug_MS(f"(navigator.playVideo[4]) ##### FORCE_SUBS = {force_Subs} || SUB_COLLECT = {subid_Collect} #####")
	LPM = xbmcgui.ListItem(path=FINAL_URL, offscreen=True)
	if plugin_operate('inputstream.adaptive'):
		IA_NAME, IA_SYSTEM = 'inputstream.adaptive', 'com.widevine.alpha'
		IA_VERSION = re.sub(r'(~[a-z]+(?:.[0-9]+)?|\+[a-z]+(?:.[0-9]+)?$|[.^]+)', '', xbmcaddon.Addon(IA_NAME).getAddonInfo('version'))[:4]
		DRM_HEADERS = {'User-Agent': agent_WEB, 'Referer': BASE_URL, 'Origin': BASE_URL[:-1], 'Content-Type': 'text/html'}
		LPM.setMimeType('application/dash+xml'), LPM.setContentLookup(False), LPM.setProperty('inputstream', IA_NAME)
		if KODI_un21:
			LPM.setProperty(f"{IA_NAME}.manifest_type", 'mpd') # DEPRECATED ON Kodi v21, because the manifest type is now auto-detected.
		if KODI_ov20:
			LPM.setProperty(f"{IA_NAME}.manifest_headers", f"User-Agent={agent_WEB}") # On KODI v20 and above
		else: LPM.setProperty(f"{IA_NAME}.stream_headers", f"User-Agent={agent_WEB}") # On KODI v19 and below
		if int(IA_VERSION) >= 2150:
			DRM_SPECIES = {'DRM_System': IA_SYSTEM, 'License_Link': DRM_GUARD, 'License_Headers': urlencode(DRM_HEADERS)} if DRM_GUARD else {'DRM_System': IA_SYSTEM}
			LPM.setProperty(f'{IA_NAME}.drm_legacy', '|'.join(DRM_SPECIES.values())) # Available from v.21.5.0 / Kodi 21 (Omega) - NEW simple method to configure a single DRM
		else:
			LPM.setProperty(f'{IA_NAME}.license_type', IA_SYSTEM)
			if DRM_GUARD:
				DRM_SPECIES = {'License_Link': DRM_GUARD, 'License_Headers': urlencode(DRM_HEADERS), 'Post_Data': 'R{SSM}|'}
				LPM.setProperty(f'{IA_NAME}.license_key', '|'.join(DRM_SPECIES.values())) # Below v.21.5.0 / Kodi 19+20 - OLD method to configure a single DRM
		if DRM_SPECIES: log(f"(navigator.playVideo[5]) INPUTSTREAM_VERSION: {IA_VERSION} >>>>> LICENSE : {'|'.join(DRM_SPECIES.values())} <<<<<")
		if force_Subs is True:
			LPM.setSubtitles([subid_Result])
		AUDIO = re.sub(r'(\[/?B\])', '', audio_Names[audio_Index]) if audio_Select else audio_Result
		SUBTITLE = re.sub(r'(\[/?B\])', '', subid_Names[subid_Index]) if subid_Select and force_Subs is True else subid_Marker if subid_Marker else 'NO SUBTITLE'
		log(f"(navigator.playVideo) MPD_stream : {FINAL_URL} || Audio : {AUDIO} || Subtitle : {SUBTITLE}")
		xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, LPM)
		if force_Subs is True:
			while not xbmc.Player().isPlaying():
				xbmc.sleep(200)
			xbmc.Player().showSubtitles(True)
	xbmc.sleep(10000)
	if not xbmc.getCondVisibility('Window.IsVisible(fullscreenvideo)') and not xbmc.Player().isPlaying():
		return dialog.notification(translation(30521).format('Video'), translation(30529), icon, 15000)

def listCategoriesTV():
	debug_MS("(navigator.listCategoriesTV) -------------------------------------------------- START = listCategoriesTV --------------------------------------------------")
	categories, simplex, DATA_ONE = {}, 'LIVE TV | Top 15', getContent(f"{API_GIZMO}/lists/live-tv-top-15", params=paras_WEB, headers=head_WEB)
	categories[simplex], coarse, DATA_TWO = [], 'DefaultAddonTvInfo.png', getContent(f"{API_GIZMO}/live_channel_categories", params=paras_WEB, headers=head_WEB)
	addDir({'mode': 'listChannelsTV', 'name': simplex}, create_entries({'Title': simplex, 'Image': coarse, 'Poster': coarse}))
	for item_uno in DATA_ONE['data']['contents'].get('data', []):
		categories[simplex].append(item_uno['id'])
	for item_due in sorted(DATA_TWO.get('data', []), key=lambda cnx: cleanUmlaut(cnx.get('name', 'zorro')).lower()):
		categories[item_due['name']] = item_due['live_channels']
		addDir({'mode': 'listChannelsTV', 'name': item_due['name']}, create_entries({'Title': item_due['name'], 'Image': coarse, 'Poster': coarse}))
	debug_MS(f"(navigator.listCategoriesTV[1]) XXXXX CATEGORIES : {categories} XXXXX")
	debug_MS("++++++++++++++++++++++++")
	preserve(CHANNEL_FILE, 0, categories)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)
	if preserve(EPGGUIDE_FILE, 1) is None:
		DATA_THREE = getContent(f"{API_GIZMO}/live_channels", params=getSpecifications(), headers=head_WEB)
		preserve(EPGGUIDE_FILE, 1, DATA_THREE)

def listChannelsTV(NAME):
	debug_MS("(navigator.listChannelsTV) -------------------------------------------------- START = listChannelsTV --------------------------------------------------")
	debug_MS(f"(navigator.listChannelsTV) ### NAME = {NAME} ###")
	FOUND, COLLAGE, EPGS_CACHE, channels = 0, [], preserve(EPGGUIDE_FILE, 1), preserve(CHANNEL_FILE, 0)
	if EPGS_CACHE is None:
		DATA_ONE = getContent(f"{API_GIZMO}/live_channels", params=getSpecifications(), headers=head_WEB)
		preserve(EPGGUIDE_FILE, 1, DATA_ONE)
	else: DATA_ONE = EPGS_CACHE
	for item in DATA_ONE.get('data', []):
		if item.get('id', '') in channels[NAME]:
			FOUND += 1
			CID = item['id']
			CHANNEL = item['title']
			LANG = item['labels']['languages'][0]['id']
			GUIDES = getSchedules(item['live_programs'])
			LOGO = (item['images'].get('artwork', '') or item['images'].get('artwork_webp', ''))
			debug_MS(f"(navigator.listChannelsTV[1]) ##### CHANNEL : {CHANNEL} || SLUG : {CID} || LANG : {LANG} || LOGO : {LOGO} #####")
			COLLAGE.append([CID, CHANNEL, LANG, GUIDES, LOGO])
	if COLLAGE and FOUND > 0:
		for CID, CHANNEL, LANG, GUIDES, LOGO in sorted(COLLAGE, key=lambda xnc: cleanUmlaut(xnc[1]).lower()):
			FETCH_UNO = create_entries({'Title': CHANNEL, 'Plot': GUIDES, 'Mediatype': 'episode', 'Image': LOGO, 'Poster': LOGO})
			addDir({'mode': 'playLive', 'action': 'RKTV', 'slug': CID, 'lang': LANG, 'name': CHANNEL, 'pic': LOGO, 'plot': GUIDES}, FETCH_UNO, folder=False)
	else:
		failing(f'(navigator.listChannelsTV) ##### NO CHANNEL-LIST - NO ENTRY FOR: "{NAME}" FOUND #####')
		return dialog.notification(translation(30525), translation(30526).format(NAME), icon, 10000)
	xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
	xbmcplugin.endOfDirectory(ADDON_HANDLE, succeeded=True, cacheToDisc=False)

def getSchedules(PROGRAM, desc='[CR]', guide_info=""):
	for elem in PROGRAM:
		start_date = datetime(*(time.strptime(elem['starts_at'][:23],'%Y-%m-%dT%H:%M:%S.000')[0:6]))
		ends_date = datetime(*(time.strptime(elem['ends_at'][:23],'%Y-%m-%dT%H:%M:%S.000')[0:6]))
		title = elem['title']
		episode = elem['subtitle'] if elem.get('subtitle', '') and len(elem['subtitle']) > 5 else None
		if elem.get('description', '') and len(elem['description']) > 10 and not 'info not available' in elem['description'].lower():
			desc = f"{elem['description'][:300].replace(chr(10), '').strip()}...[CR][CR]" if len(elem['description']) > 300 else f"{elem['description'].replace(chr(10), '').strip()}[CR][CR]"
		if ends_date > datetime.now():
			if episode is None:
				guide_info += translation(30701).format(start_date.strftime('%H:%M'), ends_date.strftime('%H:%M'), title, desc)
			else: guide_info += translation(30702).format(start_date.strftime('%H:%M'), ends_date.strftime('%H:%M'), title, episode, desc)
	return guide_info

def playLive(ACTION, SLUG, LANG, NAME, PIC, PLOT):
	debug_MS("(navigator.playLive) -------------------------------------------------- START = playLive --------------------------------------------------")
	debug_MS(f"(navigator.playLive) ### ACTION = {ACTION} ### SLUG = {SLUG} ### LANG = {LANG} ### NAME = {NAME} ### THUMB = {PIC} ###")
	specs = {"audio_language":LANG,"audio_quality":"2.0","classification_id":CLASSIFICATION,"content_id":SLUG,"content_type":"live_channels","device_make":"chrome","device_model":"GENERIC",\
		"device_serial":"not implemented","device_stream_video_quality":"HD","device_uid":addon.getSetting('device_uid'),"device_year":1970,"hdr_type": "NONE","player":"web:HLS-NONE","video_type":"stream",\
		"publisher_provided_id":addon.getSetting('publisher_provided_id'),"strict_video_quality":False,"subtitle_formats":["vtt"],"subtitle_language":"MIS","support_closed_captions":True,"support_thumbnails":True}
	DATA_ONE = getContent(f"{API_GIZMO}/avod/streamings", 'POST', params=paras_DASH, headers=head_WEB, json=specs)
	debug_MS(f"(navigator.playLive[1]) XXXXX DATA_ONE-01 : {DATA_ONE} XXXXX")
	debug_MS("++++++++++++++++++++++++")
	FINAL_URL = f"{DATA_ONE['data']['stream_infos'][0]['url']}|User-Agent={agent_WEB}&Referer={BASE_URL}"
	LTM = xbmcgui.ListItem(NAME, path=FINAL_URL, offscreen=True)
	if KODI_ov20:
		LTM.getVideoInfoTag().setTitle(NAME), LTM.getVideoInfoTag().setPlot(PLOT)
	else:
		LTM.setInfo('Video', {'Title': NAME, 'Plot': PLOT})
	LTM.setArt({'icon': icon, 'thumb': PIC, 'poster': PIC})
	if plugin_operate('inputstream.adaptive'):
		IA_NAME, IA_SYSTEM = 'inputstream.adaptive', 'com.widevine.alpha'
		IA_VERSION = re.sub(r'(~[a-z]+(?:.[0-9]+)?|\+[a-z]+(?:.[0-9]+)?$|[.^]+)', '', xbmcaddon.Addon(IA_NAME).getAddonInfo('version'))[:4]
		LTM.setMimeType('application/vnd.apple.mpegurl'), LTM.setProperty('inputstream', IA_NAME)
		if KODI_un21:
			LTM.setProperty(f'{IA_NAME}.manifest_type', 'hls') # DEPRECATED ON Kodi v21, because the manifest type is now auto-detected.
		if KODI_ov20:
			LTM.setProperty(f"{IA_NAME}.manifest_headers", f"User-Agent={agent_WEB}") # On KODI v20 and above
		else: LTM.setProperty(f"{IA_NAME}.stream_headers", f"User-Agent={agent_WEB}") # On KODI v19 and below
		if int(IA_VERSION) >= 2150:
			LTM.setProperty(f"{IA_NAME}.drm_legacy", 'org.w3.clearkey')
	log(f"(navigator.playLive) HLS_stream : {FINAL_URL}")
	if ACTION == 'IPTV':
		LTM.setProperty('IsPlayable', 'true')
		xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, LTM)
	elif ACTION =='RKTV':
		xbmc.Player().play(item=FINAL_URL, listitem=LTM)
	xbmc.sleep(5000)
	if not xbmc.getCondVisibility('Window.IsVisible(fullscreenvideo)') and not xbmc.Player().isPlaying():
		return dialog.notification(translation(30521).format('Live'), translation(30530), icon, 10000)

def generate_personaltv():
	debug_MS("(navigator.generate_personaltv) ------------------------------------------------ START = generate_personaltv -----------------------------------------------")
	if NAMING_M3U == "" or MEDIA_PATH == "":
		return dialog.ok(addon_id, translation(30503))
	dialog.notification(addon_name, translation(30534), icon, 8000)
	counter, (NAMES, CHANNELS, SELECTION) = 0, ([] for _ in range(3))
	DATA_ONE = getContent(f"{API_GIZMO}/live_channels", params=getSpecifications(), headers=head_WEB)
	NAMES.append(translation(30712).format(counter, translation(30711)))
	CHANNELS.append({'Number': counter, 'Title': translation(30711), 'TvgId': None, 'TvgLang': None, 'State': None, 'Cats': None, 'Pics': None, 'Slug': 'everything-together', 'OrgLang': None})
	for item in sorted(DATA_ONE.get('data', []), key=lambda eox: cleanUmlaut(eox.get('title', 'zorro')).lower()):
		counter += 1
		titles, idents, org_language = item['title'], item['id'], item['labels']['languages'][0]['id']
		epgcodes = cleanUmlaut(titles).replace(':', '').replace('’', '').replace("'", "").replace('!', '').replace('. ', ' ').replace(', ', ' ').replace(' + ', ' ').replace(' & ', ' ').replace(' - ', ' ').replace(' ', '-').lower()
		tvg_language = org_language.replace('DEU', 'German').replace('ENG', 'English') if org_language in ['DEU', 'ENG'] else 'English'
		countries = org_language.replace('DEU', 'DE').replace('ENG', 'UK') if org_language in ['DEU', 'ENG'] else 'UK'
		if epgcodes in ['deluxe-lounge-hd', 'ducktv', 'graham-norton', 'more-than-sports-tv', 'stingray-remember-the-80s', 'storyzoo-friends', 'tastemade', 'tennis-channel', 'the-reuters-60']: tvg_language, countries = 'English', 'UK'
		elif epgcodes in ['goldstar-tv-alles-schlager']: tvg_language, countries = 'German', 'DE'
		elif epgcodes in ['merhaba-tuerkische-serien']: tvg_language, countries = 'Turkish', 'TR'
		if item['labels'].get('tags', '') and len(item['labels']['tags']) > 0 and 'name' in str(item['labels']['tags']):
			categories = item['labels']['tags'][-1]['name'].replace('Slow TV', 'Dokumentarfilm')
		else: categories = 'Filme' if epgcodes in ['artflix', 'utopja'] else 'Nachrichten' # artflix=Filme, the-reuters-60=Nachrichten, utopja=Filme
		artworks = (item['images'].get('artwork', '') or item['images'].get('artwork_webp', ''))
		NAMES.append(translation(30712).format(counter, str(titles)))
		CHANNELS.append({'Number': counter, 'Title': titles, 'TvgId': epgcodes, 'TvgLang': tvg_language, 'State': countries, 'Cats': categories, 'Pics': artworks, 'Slug': idents, 'OrgLang': org_language})
	if len(NAMES) > 1 and len(CHANNELS) > 1:
		while xbmc.getCondVisibility('Window.IsActive(notification)'):
			xbmc.sleep(500)
		indicator = dialog.multiselect(translation(30713), NAMES, preselect=[0])
		SELECTION = [CHANNELS[cs] for cs in indicator] if indicator else []
		if len(SELECTION) == 0:
			return dialog.ok(addon_id, translation(30504))
		elif len(SELECTION) >= 1:
			COLLECTION, entries = CHANNELS if indicator == [0] else SELECTION, '#EXTM3U\n'
			debug_MS(f"(navigator.generate_personaltv[1]) ##### INDICATOR : {indicator} || SELECTION : {SELECTION} #####")
			dialog.notification(addon_name, translation(30535), icon, 8000)
			for choosen in COLLECTION:
				if choosen['Slug'] == 'everything-together': continue
				entries += f'#EXTINF:-1 tvg-id="{choosen["TvgId"]}" tvg-name="{choosen["Title"]}" tvg-language="{choosen["TvgLang"]}" tvg-country="{choosen["State"]}" tvg-shift="" radio="false" group-title="Rakuten TV - Übersicht ({MARKET_CODE.upper()});{choosen["Cats"]} - RakutenTV" tvg-logo="{choosen["Pics"]}",{choosen["Title"]}\n'
				entries += f"plugin://{addon_id}/?mode=playLive&action=IPTV&slug={choosen['Slug']}&lang={choosen['OrgLang']}&name={choosen['Title']}&pic={choosen['Pics']}\n"
			with xbmcvfs.File(f"{MEDIA_PATH}{NAMING_M3U}_{MARKET_CODE.upper()}.m3u", 'w') as new_iptv:
				new_iptv.write(entries)
			dialog.notification(addon_name, translation(30536), icon, 10000)

def getSpecifications():
	utc_start = (datetime.utcnow() - timedelta(hours=2)).strftime('%Y-%m-%dT%H:00:00.000Z') # 2025-03-10T07%3A00%3A00.000Z / 7:00
	epoch_start = TGM(time.strptime(utc_start[:19], '%Y-%m-%dT%H:%M:%S')) * 1000 # UTC-EPOCH-STARTTIME (Milliseconds=1741590000000)
	utc_ends = (datetime.utcnow() + timedelta(hours=4)).strftime('%Y-%m-%dT%H:00:00.000Z') # 2025-03-10T01%3A00%3A00.000Z / 1:00
	epoch_ends = TGM(time.strptime(utc_ends[:19], '%Y-%m-%dT%H:%M:%S')) * 1000 # UTC-EPOCH-ENDTIME (Milliseconds=1741568400000)
	terms_info = {**paras_WEB, **{'epg_duration_minutes': '360', 'epg_ends_at': utc_ends, 'epg_ends_at_timestamp': epoch_ends, \
		'epg_starts_at': utc_start, 'epg_starts_at_timestamp': epoch_start, 'page': '1', 'per_page': '200'}}
	return terms_info

def listFavorites():
	debug_MS("(navigator.listFavorites) ------------------------------------------------ START = listFavorites -----------------------------------------------")
	if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
		for each in sorted(preserve(FAVORIT_FILE, 0), key=lambda vsx: (vsx.get('Species', 'Zorro'), cleanUmlaut(vsx.get('Title', 'zorro')).lower())):
			folder, FETCH_UNO, context = True, {}, {}
			FETCHING = {'Slug': each.get('Slug'), 'Species': each.get('Species'), 'Title': each.get('Title'), \
				'Plot': each.get('Plot'), 'Year': each.get('Year'), 'Genre': each.get('Genre'), 'Rating': each.get('Rating'), \
				'Image': each.get('Image'), 'Poster': each.get('Poster'), 'Logo': each.get('Logo'), 'Fanback': each.get('Fanback')}
			if each.get('Species') == 'movies':
				folder, ACTION = False, {'mode': 'playVideo', 'slug': each.get('Slug'), 'species': each.get('Species')}
				FETCH_UNO = context = {**FETCHING, **{'Duration': each.get('Duration'), 'Mpaa': each.get('Mpaa'), 'Mediatype': 'movie', 'Reference': 'Single'}}
			elif each.get('Species') == 'tv_shows':
				folder, ACTION = True, {'mode': 'listSeasons', 'slug': each.get('Slug'), 'name': each.get('TvShowTitle')}
				FETCH_UNO = context = {**FETCHING, **{'TvShowTitle': each.get('TvShowTitle')}}
			debug_MS(f"(navigator.listFavorites[1]) ##### NAME : {each.get('Title')} || SPECIES : {each.get('Species')} || GENRE : {each.get('Genre')} || ACTION : {ACTION} #####")
			addDir(ACTION, create_entries(FETCH_UNO), folder, context, 'removing')
	xbmcplugin.setContent(ADDON_HANDLE, 'tvshows')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def favorit_construct(**kwargs):
	TOPS = []
	if xbmcvfs.exists(FAVORIT_FILE) and os.stat(FAVORIT_FILE).st_size > 0:
		TOPS = preserve(FAVORIT_FILE, 0)
	if kwargs['action'] == 'ADD':
		del kwargs['mode']; del kwargs['action']
		TOPS.append({key: value if value != 'None' else None for key, value in kwargs.items()})
		preserve(FAVORIT_FILE, 0, TOPS)
		xbmc.sleep(500)
		dialog.notification(translation(30531), translation(30532).format(kwargs['Title']), icon, 8000)
	elif kwargs['action'] == 'DEL':
		TOPS = [xs for xs in TOPS if xs.get('Slug') != kwargs.get('Slug')]
		preserve(FAVORIT_FILE, 0, TOPS)
		xbmc.executebuiltin('Container.Refresh')
		xbmc.sleep(1000)
		dialog.notification(translation(30531), translation(30533).format(kwargs['Title']), icon, 8000)

def addDir(params, listitem, folder=True, context={}, handling='default'):
	uws, entries = build_mass(params), []
	listitem.setPath(uws)
	if params.get('mode') == 'playVideo' and context:
		entries.append([translation(30721), f"RunPlugin({build_mass({'mode': 'callingInfos', 'slug': context.get('Slug')})})"])
	if handling == 'adding' and context:
		entries.append([translation(30722), f"RunPlugin({build_mass({**context, **{'mode': 'favorit_construct', 'action': 'ADD'}})})"])
	if handling == 'removing' and context:
		entries.append([translation(30723), f"RunPlugin({build_mass({**context, **{'mode': 'favorit_construct', 'action': 'DEL'}})})"])
	if len(entries) > 0: listitem.addContextMenuItems(entries)
	return xbmcplugin.addDirectoryItem(ADDON_HANDLE, uws, listitem, folder)
