﻿# -*- coding: utf-8 -*-

import sys
import os
import re
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import json
import xbmcvfs
import shutil
import uuid
import gzip
import time
from datetime import datetime, timedelta
from calendar import timegm as TGM
import requests
import ssl
from urllib.parse import parse_qsl, urlencode, quote, quote_plus, unquote_plus
from collections import ChainMap
from concurrent.futures import *
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


HOST_AND_PATH				= sys.argv[0]
ADDON_HANDLE				= int(sys.argv[1])
dialog									= xbmcgui.Dialog()
addon									= xbmcaddon.Addon()
addon_id							= addon.getAddonInfo('id')
addon_name						= addon.getAddonInfo('name')
addon_version					= addon.getAddonInfo('version')
addonPath							= xbmcvfs.translatePath(addon.getAddonInfo('path')).encode('utf-8').decode('utf-8')
dataPath								= xbmcvfs.translatePath(addon.getAddonInfo('profile')).encode('utf-8').decode('utf-8')
COUNTRY_SITE					= int(addon.getSetting('home_country'))
MARKET_CODE					= 'de' if COUNTRY_SITE == 0 else 'at' if COUNTRY_SITE == 1 else 'ch'
FAVORIT_FILE						= xbmcvfs.translatePath(os.path.join(dataPath, f'favorites_RAKUTEN_{MARKET_CODE.upper()}.gz'))
RECORD_FILE						= xbmcvfs.translatePath(os.path.join(dataPath, f'homes_data_{MARKET_CODE.upper()}.gz'))
CHANNEL_FILE					= xbmcvfs.translatePath(os.path.join(dataPath, f'channels_data_{MARKET_CODE.upper()}.gz'))
EPGGUIDE_FILE					= xbmcvfs.translatePath(os.path.join(dataPath, f'guides_data_{MARKET_CODE.upper()}.gz'))
SEARCH_FILE						= xbmcvfs.translatePath(os.path.join(dataPath, 'search_string'))
defaultFanart						= os.path.join(addonPath, 'resources', 'media', 'fanart.jpg')
icon										= os.path.join(addonPath, 'resources', 'media', 'icon.png')
artpic									= os.path.join(addonPath, 'resources', 'media', '').encode('utf-8').decode('utf-8')
LIMITATION						= int(addon.getSetting('maximum_vodentries'))
useThumbAsFanart			= addon.getSetting('use_fanart') == 'true'
prefAUDIO							= int(addon.getSetting('prefer_vodaudio'))
enableVODSUBS				= addon.getSetting('show_vodsubs') == 'true'
SUB_TYPE							= ('full' if int(addon.getSetting('vod_subtype')) == 0 else 'forced')
# ALLE, Bulgarisch, Dänisch, Deutsch, Englisch, Finnisch, Französisch, Griechisch, Italienisch, Katalanisch, Kroatisch, Litauisch, Niederländisch, Norwegisch, Ohne Untertitel, Polnisch, Portugiesisch, Rumänisch, Russisch, Schwedisch, Slowenisch, Spanisch, Türkisch, Tschechisch, Ukrainisch, Ungarisch
COUNTRY_CODE				= {0: 'AIO', 1: 'BUL', 2: 'DAN', 3: 'DEU', 4: 'ENG', 5: 'FIN', 6: 'FRA', 7: 'ELL', 8: 'ITA', 9: 'CAT', 10: 'HRV', 11: 'LIT', 12: 'NLD', 13: 'NOR', 14: 'MIS', 15: 'POL', 16: 'POR', 17: 'RON', 18: 'RUS', 19: 'SWE', 20: 'SLV', 21: 'SPA', 22: 'TUR', 23: 'CES', 24: 'UKR', 25: 'HUN'}[int(addon.getSetting('vod_sublanguage'))]
# Available Languages(settings) ~ Selection=0|Bulgarian=1|Danish=2|German=3|English=4|Finnish=5|French=6|Greek=7|Italian=8|Katalanian=9|Croatian=10|Lithuanian=11|Dutch=12|Norwegian=13|NONE=14|Polish=15|Portuguese=16|Romanian=17|Russian=18|Swedish=19|Slovenian=20|Spanish=21|Turkish=22|Czech=23|Ukrainian=24|Hungarian=25
# Language Codes(Rakuten.tv) = 0: AIO|1: BUL|2: DAN|3: DEU|4: ENG|5: FIN|6: FRA |7: ELL|8: ITA|9: CAT|10: HRV|11: LIT|12: NLD|13: NOR|14: MIS|15: POL|16: POR|17: RON|18: RUS|19: SWE|20: SLV|21: SPA|22: TUR|23: CES|24: UKR|25: HUN
NAMING_M3U					= addon.getSetting('naming_m3u')
MEDIA_PATH						= addon.getSetting('media_path')
enableADJUSTMENT			= addon.getSetting('show_settings') == 'true'
textSelection						= int(addon.getSetting('field_spread'))
DEB_LEVEL							= (xbmc.LOGINFO if addon.getSetting('enable_debug') == 'true' else xbmc.LOGDEBUG)
KODI_ov20							= int(xbmc.getInfoLabel('System.BuildVersion')[0:2]) >= 20
KODI_un21							= int(xbmc.getInfoLabel('System.BuildVersion')[0:2]) <= 20
BASE_URL							= 'https://www.rakuten.tv/'
API_GIZMO						= 'https://gizmo.rakuten.tv/v3'
CHECK_URL						= 'https://ip-api.io/json/'
CLASSIFICATION				= '307' if COUNTRY_SITE == 0 else '300' if COUNTRY_SITE == 1 else '319'
LOCALE_CODE					= 'de' if COUNTRY_SITE == 0 else 'de-AT' if COUNTRY_SITE == 1 else 'de-CH'
agent_WEB							= 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36'
head_COUN						= {'User-Agent': agent_WEB, 'DNT': '1', 'Accept-Encoding': 'gzip', 'Accept-Language': 'de-DE,de;q=0.9,en;q=0.8'}
head_WEB							= {'User-Agent': agent_WEB, 'Origin': BASE_URL[:-1], 'Referer': BASE_URL, 'DNT': '1', 'Accept-Language': 'de-DE,de;q=0.9,en;q=0.8', 'Accept-Encoding': 'gzip, deflate, br', 'Accept': 'application/json, text/plain, */*', 'Content-Type': 'application/json; charset=utf-8'}
paras_WEB							= {'classification_id': CLASSIFICATION, 'device_identifier': 'web', 'device_stream_audio_quality': '2.0', 'device_stream_hdr_type': 'NONE', 'device_stream_video_quality': 'FHD', 'locale': LOCALE_CODE, 'market_code': MARKET_CODE}
paras_USER						= {**paras_WEB, **{'live_channel_support': 'true', 'user_status': 'visitor'}}
paras_DASH						= {**paras_WEB, **{'disable_dash_legacy_packages': 'false'}}

def py3_dec(d, nom='utf-8', ign='ignore'):
	if isinstance(d, bytes):
		d = d.decode(nom, ign)
	return d

def translation(id):
	return addon.getLocalizedString(id)

def failing(content):
	log(content, xbmc.LOGERROR)

def debug_MS(content):
	log(content, DEB_LEVEL)

def log(msg, level=xbmc.LOGINFO):
	return xbmc.log(f"[{addon_id} v.{addon_version}]{str(msg)}", level)

def build_mass(body):
	return f"{HOST_AND_PATH}?{urlencode(body)}"

def getMultiData(MURLS, method='GET', timeout=5, retries=2):
	COMBI_NEW, number = [], len(MURLS)
	def download(pos, url):
		UNCHECK = ssl.create_default_context()
		UNCHECK.check_hostname = False
		UNCHECK.verify_mode = ssl.CERT_NONE
		connector = urllib3.PoolManager(block=True, ssl_context=UNCHECK, maxsize=25)
		with connector.request(method, f"{API_GIZMO}/skeleton/gardens/free", fields=paras_USER, headers=head_WEB, preload_content=False, redirect=True, timeout=timeout, retries=retries) as mrs:
			if mrs.status in [200, 201, 202]:
				response = connector.request(method, url, fields=paras_WEB, headers=head_WEB, redirect=True, timeout=timeout, retries=retries)
				if response.status in [200, 201, 202]:
					debug_MS(f"(common.getMultiData[1]) === POS : {pos} === URL : {url}{'?'+urlencode(paras_WEB)} === HEADER : {head_WEB} ===")
					return f'{{"Position":{pos},"Demand":"{url}",{py3_dec(response.data[1:-1])}}}'
				else:
					failing(f"(common.getMultiData[1]) ERROR - RESPONSE - ERROR ##### POS : {pos} === STATUS : {response.status} === URL : {url}{'?'+urlencode(paras_WEB)} === DATA : {py3_dec(response.data)} #####")
					return '{"ERROR_occurred":true}'
		connector.clear()
	with ThreadPoolExecutor() as executor:
		picker = [executor.submit(download, pos, url) for pos, url in MURLS]
		wait(picker, timeout=30, return_when=ALL_COMPLETED)
		for ii, future in enumerate(as_completed(picker), 1):
			try:
				COMBI_NEW.append(json.loads(future.result()))
			except Exception as exc:
				failing(f"(common.getMultiData[2]) ERROR - EXEPTION - ERROR ##### FUTURE_RESULT : {future.result()} === FAILURE : {exc} #####")
				dialog.notification(translation(30521).format('DETAILS'), translation(30523).format(exc), icon, 10000)
				executor.shutdown()
		if COMBI_NEW:
			debug_MS("---------------------------------------------")
			matching = [flop for flop in COMBI_NEW[:] if flop.get('ERROR_occurred', '') is True]
			if len(matching) == number or len(matching) > 3:
				dialog.notification(translation(30521).format('DETAILS'), translation(30524), icon, 10000)
		return json.dumps(COMBI_NEW, indent=2)

def getContent(url, method='GET', queries='JSON', params={}, headers={}, redirects=True, verify=False, data=None, json=None, timeout=30):
	ANSWER = None
	try:
		response = requests.request(method, url, params=params, headers=headers, allow_redirects=redirects, verify=verify, data=data, json=json, timeout=timeout)
		ANSWER = response.json() if queries == 'JSON' else response.text if queries == 'TEXT' else response
		debug_MS(f"(common.getContent) === CALLBACK === STATUS : {response.status_code} || URL : {response.url} || HEADER : {response.request.headers} || JSON : {json} ===")
		debug_MS("---------------------------------------------")
		if queries == 'JSON' and not isinstance(response.json(), list) and response.json().get('errors', ''):
			message = (response.json().get('errors', {})[0].get('message', '') or 'NO DETAILS FOUND')
			failing(f"(utilities.retrieveContent) ERROR - RESPONSE - ERROR ##### URL : {url} === DETAIL : {message} #####")
			dialog.notification(translation(30521).format('URL'), translation(30523).format(message), icon, 10000)
			return sys.exit(0)
		response.raise_for_status()
	except Exception as exc: # No JSON object could be decoded
		failing(f"(common.getContent) ERROR - EXEPTION - ERROR ##### URL : {url} === FAILURE : {exc} #####")
		dialog.notification(translation(30521).format('URL'), translation(30523).format(exc), icon, 10000)
		return sys.exit(0)
	return ANSWER

def country_check(COU_NAME='UNKNOWN', COU_FLAG='unk', redirects=True, verify=False, timeout=20):
	try: # https://flagcdn.com/h240/ua.png // https://flagpedia.net/download/api
		results = requests.request('GET', CHECK_URL, headers=head_COUN, allow_redirects=redirects, verify=verify, timeout=timeout)
		results.raise_for_status()
		COU_NAME, COU_FLAG = results.json().get('countryName', 'UNKNOWN'), f"https://flagcdn.com/256x192/{results.json().get('countryCode', 'unk').lower()}.png"
		debug_MS(f"(common.country_check) === CALLBACK === STATUS : {results.status_code} || URL : {results.url} || HEADER : {head_COUN} || DATA : {results.text} ===")
	except Exception as exc: # No JSON object could be decoded
		failing(f"(common.country_check) ERROR - EXEPTION - ERROR ##### URL : {CHECK_URL} === FAILURE : {exc} #####")
		dialog.notification(translation(30521).format('IP_CHECK'), translation(30523).format(exc), icon, 10000)
	return (COU_NAME, COU_FLAG)

def plugin_operate(MARKING):
	check_uno = xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.GetAddonDetails","params":{{"addonid":"{MARKING}","properties":["enabled"]}}}}')
	answer_uno, answer_due = json.loads(check_uno), json.loads(f'{{"error": "{MARKING} NOT FOUND"}}')
	if not "error" in answer_uno.keys() and answer_uno.get('result', '') and answer_uno['result'].get('addon', {}).get('enabled', False) is False:
		try:
			xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.SetAddonEnabled","params":{{"addonid":"{MARKING}","enabled": true}}}}')
			failing(f"(common.plugin_operate) ERROR - ACTIVATED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT aktiviert !!! #####\n##### Es wird jetzt versucht die Aktivierung durchzuführen !!! #####")
		except: pass
		del answer_due
		check_due = xbmc.executeJSONRPC(f'{{"jsonrpc":"2.0","id":1,"method":"Addons.GetAddonDetails","params":{{"addonid":"{MARKING}","properties":["enabled"]}}}}')
		answer_due = json.loads(check_due)
	if (answer_uno.get('result', '') and answer_uno['result'].get('addon', {}).get('enabled', False) is True) or (answer_due.get('result', '') and answer_due['result'].get('addon', {}).get('enabled', False) is True):
		return True
	if answer_due.get('result', '') and answer_due['result'].get('addon', {}).get('enabled', False) is False:
		dialog.ok(addon_id, translation(30501).format(MARKING))
		failing(f"(common.plugin_operate) ERROR - ACTIVATED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT aktiviert !!! #####\n##### Eine automatische Aktivierung ist leider NICHT möglich !!! #####")
	if "error" in answer_uno.keys() or "error" in answer_due.keys():
		dialog.ok(addon_id, translation(30502).format(MARKING))
		failing(f"(common.plugin_operate) ERROR - INSTALLED - ERROR :\n##### Das benötigte Addon : *{MARKING}* ist NICHT installiert !!! #####")
	return False

def preserve(store, timing, facts=None, arrive=None): # timing = 12 Hours storing of RECORD_FILE / 0 or 1 for all other FILES
	if facts is not None:
		with gzip.open(store, 'wt', encoding='utf-8') as topics:
			json.dump(facts, topics, indent=2, sort_keys=True)
	else:
		if xbmcvfs.exists(store) and os.path.exists(store) and os.stat(store).st_size > 0:
			NOW_UTC, FILE_UTC = time.time(), (os.path.getmtime(store) + 60*60*int(timing)) if int(timing) != 0 else int(timing)
			if int(timing) == 0 or (int(timing) != 0 and NOW_UTC < FILE_UTC):
				with gzip.open(store, 'rt', encoding='utf-8') as topics:
					arrive = json.load(topics)
			else: xbmcvfs.delete(store)
		return arrive

def cleanUmlaut(wrong):
	if wrong is not None:
		for wg in (('ä', 'ae'), ('Ä', 'Ae'), ('ü', 'ue'), ('Ü', 'Ue'), ('ö', 'oe'), ('Ö', 'Oe'), ('ß', 'ss')):
			wrong = wrong.replace(*wg)
		wrong = wrong.strip()
	return wrong

def create_entries(metadata, SIGNS=None):
	listitem = xbmcgui.ListItem(metadata['Title'])
	vinfo = listitem.getVideoInfoTag() if KODI_ov20 else {}
	if KODI_ov20: vinfo.setTitle(metadata['Title'])
	else: vinfo['Title'] = metadata['Title']
	if metadata.get('TvShowTitle', ''):
		if KODI_ov20: vinfo.setTvShowTitle(metadata['TvShowTitle'])
		else: vinfo['Tvshowtitle'] = metadata['TvShowTitle']
	description = metadata['Plot'] if metadata.get('Plot') not in ['', 'None', None] else ' '
	if KODI_ov20: vinfo.setPlot(description)
	else: vinfo['Plot'] = description
	if str(metadata.get('Duration')).isdecimal():
		if KODI_ov20: vinfo.setDuration(int(metadata['Duration']))
		else: vinfo['Duration'] = metadata['Duration']
	if str(metadata.get('Season')).isdecimal():
		if KODI_ov20: vinfo.setSeason(int(metadata['Season']))
		else: vinfo['Season'] = metadata['Season']
	if str(metadata.get('Episode')).isdecimal():
		if KODI_ov20: vinfo.setEpisode(int(metadata['Episode']))
		else: vinfo['Episode'] = metadata['Episode']
	if str(metadata.get('Year')).isdecimal():
		if KODI_ov20: vinfo.setYear(int(metadata['Year']))
		else: vinfo['Year'] = metadata['Year']
	if metadata.get('Genre', ''):
		if KODI_ov20: vinfo.setGenres([metadata['Genre']])
		else: vinfo['Genre'] = metadata['Genre']
	if metadata.get('Country', ''):
		if KODI_ov20: vinfo.setCountries([metadata['Country']])
		else: vinfo['Country'] = metadata['Country']
	if metadata.get('Director', ''):
		if KODI_ov20: vinfo.setDirectors([metadata['Director']])
		else: vinfo['Director'] = metadata['Director']
	if metadata.get('Cast', '') and isinstance(metadata.get('Cast'), (list, tuple)):
		if KODI_ov20: vinfo.setCast(metadata['Cast'])
		else: listitem.setCast(metadata['Cast'])
	if metadata.get('Rating', ''):
		if KODI_ov20: vinfo.setRating(float(metadata['Rating']), 0, 'imdb', True) # vinfo.setRating(4.6, 8940, "imdb", True) since NEXUS and UP
		else: listitem.setRating('imdb', float(metadata['Rating']), 0, True) # LSM.setRating("imdb", 4.6, 8940, True) below NEXUS (MATRIX)
	if metadata.get('Mpaa', ''):
		if KODI_ov20: vinfo.setMpaa(str(metadata['Mpaa']))
		else: vinfo['Mpaa'] = str(metadata['Mpaa'])
	if metadata.get('Studio', ''):
		if KODI_ov20: vinfo.setStudios([metadata['Studio']])
		else: vinfo['Studio'] = metadata['Studio']
	if metadata.get('Mediatype', ''):
		if KODI_ov20: vinfo.setMediaType(metadata['Mediatype'])
		else: vinfo['Mediatype'] = metadata['Mediatype']
	picture, portrait, piclogo = metadata.get('Image', icon), (metadata.get('Poster', '') or metadata.get('Image', icon)), metadata.get('Logo', None)
	listitem.setArt({'icon': icon, 'thumb': picture, 'poster': portrait, 'clearlogo': piclogo, 'fanart': defaultFanart})
	if useThumbAsFanart and metadata.get('Fanback', ''):
		listitem.setArt({'fanart': metadata['Fanback']})
	if metadata.get('Reference') == 'Single':
		listitem.setProperty('IsPlayable', 'true')
	if not KODI_ov20: listitem.setInfo('Video', vinfo)
	return listitem
