# -*- coding: utf-8 -*-
import sys
import six
import os
if six.PY2:
    reload(sys)
    sys.setdefaultencoding('utf-8')
if six.PY3:
    from urllib.parse import urlparse, parse_qs, quote, unquote, quote_plus, unquote_plus, urlencode #python 3
else:
    from urlparse import urlparse, parse_qs #python 2
    from urllib import quote, unquote, quote_plus, unquote_plus, urlencode
import re
try:
    from kodi_six import xbmc, xbmcgui, xbmcplugin, xbmcaddon, xbmcvfs
    handle = int(sys.argv[1])
    addon = xbmcaddon.Addon()
    addonname = addon.getAddonInfo('name')
    addonid = addon.getAddonInfo('id')
    icon = addon.getAddonInfo('icon')
    translate = xbmcvfs.translatePath if six.PY3 else xbmc.translatePath
    home = translate(addon.getAddonInfo('path')) if six.PY3 else translate(addon.getAddonInfo('path')).decode('utf-8')
    profile = translate(addon.getAddonInfo('profile')) if six.PY3 else translate(addon.getAddonInfo('profile')).decode('utf-8')
    listitem = xbmcgui.ListItem
    adddirectory = xbmcplugin.addDirectoryItem
    enddirectory = xbmcplugin.endOfDirectory
    content = xbmcplugin.setContent
    player = xbmcplugin.setResolvedUrl
    dialog = xbmcgui.Dialog()
    keyboard = xbmc.Keyboard
    fanart_default = os.path.join(home, 'fanart.png')
    password = addon.getSetting('parental_pass')
    if not os.path.exists(profile):
        try:
            os.mkdir(profile)
        except:
            pass       
except:
    addonname = 'HENTAI'     


def icons(name):
    try:
        icon = os.path.join(home, 'resources', 'images', '%s.png'%name)
    except:
        icon = ''
    return icon

try:
    base = sys.argv[0]
except:
    base = ''

def set_content(value='video'):
    try:
        content(handle, value)
    except:
        pass

def end(cache=True):
    try:
        enddirectory(handle,cacheToDisc=cache)
    except:
        pass

def set_view(name):
    mode = {'Wall': '500',
            'List': '50',
            'Poster': '51',
            'Shift': '53',
            'InfoWall': '54',
            'WideList': '55',
            'Fanart': '502'
            }
    try:
        xbmc.executebuiltin('Container.SetViewMode(%s)'%mode[name])
    except:
        pass

def open_settings():
    try:
        addon.openSettings()
    except:
        pass

def infoDialog(message, heading=addonname, iconimage='', time=3000, sound=False):
    try:
        if iconimage == '':
            iconimage = icon
        elif iconimage == 'INFO':
            iconimage = xbmcgui.NOTIFICATION_INFO
        elif iconimage == 'WARNING':
            iconimage = xbmcgui.NOTIFICATION_WARNING
        elif iconimage == 'ERROR':
            iconimage = xbmcgui.NOTIFICATION_ERROR
        dialog.notification(heading, message, iconimage, time, sound=sound)
    except:
        pass

def ok(message):
    try:
        dialog.ok(addonname, message)
    except:
        pass

def open_settings():
    try:
        addon.openSettings()
    except:
        pass


def notify(msg):
    infoDialog(msg, iconimage='INFO')                                            

def kversion():
    try:
        full_version_info = xbmc.getInfoLabel('System.BuildVersion')
        baseversion = full_version_info.split(".")
        intbase = int(baseversion[0])
        return intbase
    except:
        return 20
    
def to_unicode(text, encoding='utf-8', errors='strict'):
    """Force text to unicode"""
    if isinstance(text, bytes):
        return text.decode(encoding, errors=errors)
    return text

def get_search_string(heading='', message=''):
    try:
        """Ask the user for a search string"""
        search_string = None
        k = keyboard(message, heading)
        k.doModal()
        if k.isConfirmed():
            search_string = to_unicode(k.getText())
        return search_string
    except:
        return ''
    
def search():
    try:
        vq = get_search_string(heading='Pesquisa', message="")        
        if ( not vq ): return False
        return vq
    except:
        return ''

def search2():
    try:
        vq = get_search_string(heading='Pesquisa', message="")        
        if ( not vq ): return False
        return quote(vq)
    except:
        return ''        

def item(params, destiny='', folder=True):
    try:
        destiny = destiny.split('/')[1]
    except:
        pass
    try:
        u = 'plugin://%s/%s/%s'%(base.split("/")[2],destiny,quote_plus(urlencode(params)))
        #u = f'plugin://{base.split("/")[2]}/{destiny}/{quote_plus(urlencode(params))}'
        liz = listitem(params['name'])
        liz.setArt({'fanart': params.get('fanart', fanart_default), 'thumb': params.get('iconimage', ''), 'icon': "DefaultFolder.png"})
        if kversion() > 19:
            info = liz.getVideoInfoTag()
            info.setTitle(params.get('name', ''))
            info.setMediaType('video')
            info.setPlot(params.get('description', ''))
        else:
            liz.setInfo(type="Video", infoLabels={"Title": params.get('name', ''), 'mediatype': 'video', "Plot": params.get('description', '')})
        if params.get('playable', '') == 'true':
            liz.setProperty('IsPlayable', 'true')
        adddirectory(handle=handle, url=u, listitem=liz, isFolder=folder)
    except:
        pass


def play_item(params):
    try:
        name = params['name']
        stream = params.get('url', '')
        description = params.get('description', '')
        iconimage = params.get('iconimage', '')
        fanart = params.get('fanart', '')
        playable = params.get('playable', '')
        if stream:        
            liz = listitem(name)
            if kversion() > 19:
                info = liz.getVideoInfoTag()
                info.setTitle(name)
                info.setMediaType('video')
                info.setPlot(description)
            else:
                liz.setInfo(type="Video", infoLabels={"Title": name, 'mediatype': 'video', "Plot": description})
            liz.setArt({"fanart": fanart, "icon": iconimage, "thumb": iconimage})                     
            liz.setPath(stream)
            if playable == 'true':
                player(int(sys.argv[1]), True, liz)
            else:
                xbmc.Player().play(item=stream, listitem=liz)
        else:
            dialog.notification(addonname, 'Stream indisponivel', xbmcgui.NOTIFICATION_INFO, 3000, sound=False)
    except:
        pass



def default_player(param):
    name = unquote_plus(param.get('name', 'HENTAI'))
    playable = unquote_plus(param.get('playable', ''))
    url = unquote_plus(param.get('url', ''))
    description = unquote_plus(param.get('description', ''))
    iconimage = unquote_plus(param.get('iconimage', ''))
    fanart = unquote_plus(param.get('fanart', ''))
    param = {'name': name, 'url': url, 'description': description, 'iconimage': iconimage, 'fanart': fanart, 'playable': playable}
    play_item(param)
    


def route(r):
    try:
        route_decorator = r.split('/')[1] # function name from route
        plugin_route = base.split('/')[3:] # command from sys
        route_sys = plugin_route[0] # function name from sys
        def decorator(f):
            params = {}
            try:
                param_root = plugin_route[1] # params from sys
                param_root = unquote_plus(param_root).split('&')
                for command in param_root:
                    if '=' in command:
                        split_command = command.split('=')
                        key = split_command[0]
                        value = split_command[1]
                        params[key] = value
                    else:
                        params[command] = ''
            except:
                pass
            if not route_decorator and not route_sys:
                try:
                    f(params)
                except:
                    f()
            elif route_decorator == route_sys:
                try:
                    f(params)
                except:
                    f()
        return decorator
    except:
        def decorator(f):
            return f
        return decorator